indexing
	description	: "Sorts a given list of actual MP3_files and moves if wished them on the hd. The criterias are id3-tag artist, title and then the filename "
	author: "David Murer"
	revision: "0.1.0"

class
	MP3_SORT

create
	make_with_files --make_with_files

feature -- Initialization

--	make is
--			-- Creation procedure.
--		local
--			files: LINKED_LIST[STRING]
--			dir: MP3_DIRECTORY[MP3_FILE]
--			dir2: DIRECTORY
--			f: STRING
--		do
--		create files.make
--		create dir2.make("/windows-data/mp3/")
--		dir2.open_read
--		from
--			f:="filler"
--		until
--			f = void
--		loop
--			dir2.readentry
--			f:= dir2.lastentry
--			if f /= void then
--			files.extend("/windows-data/mp3/" +f)
--			io.print(dir2.lastentry)
--			io.put_new_line
--			end
--		end
--		io.print(files.out)
----			files.extend("a/b")
----			files.extend("a/c")
----			files.extend("a/d")
----			files.extend("a/e")
----			files.extend("a/f")
----			files.extend("a/g")
----			files.extend("a/h")
----			files.extend("a/i")
----			files.extend("a/j")
----			files.extend("a/k")
--			set_mp3_files(files)
--		create dir.make_with_name("Unreconizable")
--			create sorted.make(0)
--			sorted.extend(dir)	
--			create sorted_name.make(0)
--		sorted_name.extend("THIS_IS_A_FILLER")
--			sort
--	move("test/",true)
--		ensure
--			sorted_not_empty: sorted /= void and then not sorted.is_empty
--			sorted_name_not_empty: sorted_name /= void and then not sorted_name.is_empty
--	
--		end
		
	feature make_with_files(files: LINKED_LIST[STRING])is
			-- create with files 
		require
			files_not_void: files /= void
			local
				dir: MP3_DIRECTORY[MP3_FILE]
		do
			set_mp3_files(files)
			create dir.make_with_name("Unreconizable")
			create sorted.make(1)
			sorted.extend(dir)
			create sorted_name.make(1)
			sorted_name.extend("FILLER")
			sorted_name.compare_objects
	
			
		ensure
			sorted_not_empty: sorted /= void and then not sorted.is_empty
			sorted_name_not_empty: sorted_name /= void and then not sorted_name.is_empty
		end
		
feature mp3_files: LIST[STRING] 
			--alle pfadangaben der files die sortiert werden m  ssen
			
feature sorted:  ARRAYED_LIST[MP3_DIRECTORY[MP3_FILE]]

feature sorted_name: ARRAYED_LIST[STRING]
	
feature set_mp3_files(files: LIST[STRING]) is
			--alle pfadangaben der files die sortiert werden m  ssen
	do
				mp3_files:= files
				
	end	

			
feature sort is
--sortiert alle mp3files in mp3_files und setzt die liste sorted[MP3_DIRECTORY]	

local
	index:  INTEGER
	mp3file: MP3_FILE
	dir_name: STRING
	exist: BOOLEAN
	temp_dir: MP3_DIRECTORY[MP3_FILE]
	i: INTEGER


	do
 	from
	 		mp3_files.start
	 until
	 		mp3_files.after
 	loop
	 	create mp3file.make(mp3_files.item)

	 	if mp3file.exists and (mp3_files.item.substring(mp3_files.item.count-2,mp3_files.item.count).is_equal("mp3") or  mp3_files.item.substring(mp3_files.item.count-2,mp3_files.item.count).is_equal("MP3")) then 
			mp3file.parse
 			dir_name:= mp3file.artist
	 		if dir_name /= void then
			dir_name:= multiple_space_elim(dir_name)
 			dir_name:= null_elimination (dir_name)
 			sorted_name.go_i_th(1)
	 		exist:= sorted_name.has(dir_name.as_lower)
	 		io.print("ARTIST= ") io.print(mp3file.artist)
 			io.put_new_line
 			io.print("TITLE= ") io.print(mp3file.title)
 			io.put_new_line
 			io.print("ID3-VERSION, 0 if none: ")io.print(mp3file.id3_version)
 			io.put_new_line

	 					if exist then
	 						sorted_name.go_i_th (1)
	 						sorted_name.search(dir_name.as_lower)
	 						index:= sorted_name.index
	 						sorted.go_i_th(index)
	 						temp_dir:= sorted.item
	 						temp_dir.extend(mp3file)
	 						sorted.put(temp_dir)
	 					else
	 						create temp_dir.make_with_name(dir_name)
	 						temp_dir.extend(mp3file)
							sorted.extend(temp_dir)
							sorted_name.extend(dir_name.as_lower)
							
	 					end --exist end
	 		else
	 			
	 			sorted.go_i_th(1)
	 			temp_dir:= sorted.item
	 			temp_dir.extend(mp3file)
	 			sorted.put(temp_dir)
	 			
	 		end --dir_name end

		end --mp3file exists end
		mp3_files.forth
end --loop end

--
--from
--	temp_dir:= sorted.first
--	index:= 1
--until
--	index > temp_dir.count
--	
--loop
--	mp3file:= temp_dir.i_th(index)
--	file_name_comparision(mp3file.file_name)
--	index:= index+1
--end


	ensure
		sorted_not_void: sorted /= void
end





feature move(target: STRING yes: BOOLEAN) is 
		--verschiebt die files auf der festplatte falls gewuenscht und gibt ihnen noch einen neuen namen aus dem --id3-tag (falls vorhanden)
require 
		sorted_not_void: sorted /= void
		target_not_void: target /= void		
		
	local
			temp_file: MP3_FILE
			temp_dir: MP3_DIRECTORY[MP3_FILE]
			temp_dir_phys: DIRECTORY
			ex: BOOLEAN
			path: STRING
			j,i: INTEGER
			dir_path: STRING
			old_path: STRING


	do

			if yes then
				
				from
					sorted.start
					j:= 1
				until
				j > sorted.count
				loop
					temp_dir:= sorted.item
					dir_path:= target + "/" + temp_dir.name
		
					create temp_dir_phys.make(dir_path)
						ex:= temp_dir_phys.exists
						if not ex then
							temp_dir_phys.create_dir
						end
						from
							temp_dir.start
							i:= 1
						until
							i > temp_dir.count
						
						loop
							temp_file:= temp_dir.item
--							if ex then
--							path:= dir_path+"/"+temp_file.new_name
--							else
--							path:= dir_path+"/"+temp_file.new_name
--							end	
							path:= dir_path+"/"+temp_file.new_name
							path:= null_elimination(path)
							path:= multiple_space_elim(path)
							temp_file.copy_file(path)
							io.print(path)
							io.put_new_line
--							old_path:= temp_file.name
--							temp_file.change_name(path)
--							if  temp_file.exists then
--							temp_file.change_name(old_path)
--							io.print(old_path)
--							io.put_new_line
--							temp_file.delete
						--	end
						
							i:= i+1
							temp_dir.forth
						end
					sorted.forth
					j:= j+1
				end
				io.print("Finished!")
				io.put_new_line
				
			end
	
	end
	
feature null_elimination(temp_string: STRING): STRING is
		-- eliminates all the characters with code "0"  of a string
		require
			temp_string_not_void: temp_string /= void
		local 
			j: INTEGER	
		do
			from 
					j:=1
			until
					j>temp_string.count
			loop
					if temp_string.item(j).code=0 then
						temp_string.remove(j)
					end
						j:=j+1
					end
			Result:= temp_string
		end




	feature multiple_space_elim(temp_string: STRING): STRING is
			-- eleminates multiple spaces out of the string
			require
				temp_string_not_void: temp_string /= void
			local
				i: INTEGER
			do
				from
					i:= 1
				until
					i>temp_string.count
				loop
					if temp_string.item(i).code = 32 and  i=temp_string.count then
					temp_string.remove(i)
					i:=i-1
					elseif temp_string.item(i).code = 32 and temp_string.item(i+1).code = 32 then
					temp_string.remove(i)
					i:= i-1
					elseif temp_string.item(i).code = 32 and temp_string.item(i+1).code = 46 then
						temp_string.remove(i)
						i:= i-1
					end
					i:=i+1
				end
				Result:=temp_string
			end
		


feature	file_name_comparision(input: STRING)is
		-- compares the file name with all the directories and returns a value how good their matching
	require
		sorted_name_not_void: sorted_name /= void
		input_not_void: input /= void
		input_count_non_zero: input.count /= 0
	local
		temp_string, temp_string2,temp_art: STRING
		matches,j,i,first,c,k: INTEGER
		quotient: REAL
	
	
	do
		from
			i:= 1
			matches:= 1
		until
			i>(input.count-2)
		loop
			temp_string:= input.substring(i,i+2)
			
					from
						j:= 1
					until
						j>sorted_name.count
					loop
						if sorted_name.i_th(j).has_substring(temp_string) then
							temp_art:= sorted_name.i_th(j)
							temp_string:= temp_string.substring(i,temp_string.count)						
							temp_string:= temp_string.as_lower
							first:= sorted_name.i_th(j).substring_index(temp_string,1)
							temp_string2:= sorted_name.i_th(j).substring(first,sorted_name.i_th(j).count)
							temp_string2:= temp_string2.as_lower
							if temp_string.count >= temp_string2.count	then
								c:= temp_string2.count
							else
								c:= temp_string.count
							end --temp_string_count-end
						
								from
									k:= 1
									matches:= 3
								until
									k>c
								loop
									if temp_string.item(k)= temp_string2.item(k)then
									matches:= matches+1
									end	
									io.print("I_LOOP "+k.out)
									io.put_new_line
									k:=k+1
								end--chars-match-loop-end
							
							i:= input.count
							j:= sorted_name.count
							
						end --has_substring-end
						io.print("I_LOOP "+j.out)
						io.put_new_line
						
						j:=j+1
						
					end--sorted-end
			
			i:=i+1
			io.print("I_LOOP "+i.out)
			io.put_new_line
		end --temp_string-loop
		if matches /= 1 then
			io.print("ARTIST:= ")io.print(temp_art)
		quotient:= matches/input.count
		io.print(quotient.out)
		io.put_new_line
		io.print(input)
		io.put_new_line
		else
			io.print("MATCHES= 1")
			io.put_new_line
		end

	end
	
invariant
	mp3_files_not_void: mp3_files /= void
			

end -- class MP3_SORT
