indexing
	description: "MP3-File with features to parse the ID3-TAG"
	author: "David Murer"
	 date: "$Date: 2005/1/24 18:09:00 $"
	revision: "0.1.0"

class
	MP3_FILE
inherit
	KL_TEXT_INPUT_FILE
	redefine make  end

	
create make

feature make (f:  STRING) is
		-- mp3 file make
require else f_not_void: f  /= void
	do
	PRECURSOR(f)
	possible_tags:= "AENC,APIC,COMM,COMR,EQUA,ETCO,GEOB,GRID,IPLS,LINK,MCDI,MLLT,OWNE,PRIV,PCNT,POPM,POSS,RBUF,RVAD,RVRB,SYLT,SYTC,TALB,TBPM,TCOM,TCON,TCOP,TDAT,TDLY,TENC,TEXT,TFLT,TIME,TIT1,TIT2,TIT3,TKEY,TLAN,TLEN,TMED,TOAL,TOFN,TOLY,TOPE,TORY,TOWN,TPE1,TPE2,TPE3,TPE4,TPOS,TPUB,TRCK,TRDA,TRSN,TRSO,TSIZ,TSRC,TSSE,TYER,TXXX,UFID,USER,USLT,WCOM,WCOP,WOAF,WOAR,WOAS,WORS,WPAY,WPUV,WXXX"

	end


feature --access

has_id3: BOOLEAN
has_art: BOOLEAN
has_tit: BOOLEAN
read_out_string: STRING
possible_tags: STRING
id3_version: INTEGER
artist: STRING
title: STRING



		
feature new_name: STRING is
		-- gives the name of the file which would be written on the hd, composed of the id3-tag if there is one

		do
			if artist /= void and title /= void then
			Result:= artist + " - " + title + ".mp3"
			else
			Result:= file_name
			end
		ensure
			result_not_void: Result /= void 
			name_unchanged_implies: Result.is_equal(name) implies artist = void or title = void
		end	
		
feature file_name: STRING is
		-- gives the file name of the file (not the path)
		require
			name_not_void: name /= void
		local
			temp_string: STRING
			i: INTEGER
		do
			temp_string:= name
			from
				i:= temp_string.count
			until
				i<=1
			loop
					if temp_string.item(i).code= 47 and i /= temp_string.count then
						temp_string:= temp_string.substring(i+1,temp_string.count)
						i:= 1
					end
				i:= i-1
			end
			Result:= temp_string
		ensure
			name_set: Result /= void

		end
	
	
feature parse is
	-- find out the properties of the mp3file
		local 
		first_string, end_string, temp_art, temp_tit: STRING
		i,c: INTEGER
		do
			c:= count
			open_read
			read_string(c)
			first_string:= last_string.substring(1, 800)
			if first_string.has_substring("ID3") then
				read_out_string:= first_string
				has_art:= read_out_string.has_substring("TIT2")
				has_tit:= read_out_string.has_substring("TPE1")
				has_id3:= true
				id3_version:= 2
				if has_art then artist_parse end
				if has_tit then title_parse end			
			end		
				
			end_string:= last_string.substring(c -400, c)	
			if not has_art and not has_tit and then end_string.has_substring("TAG") then
					i:= end_string.substring_index("TAG",1)
					has_art:= true
					has_id3:= true
					temp_tit:= end_string.substring(i+3,i+29)
					temp_art:= end_string.substring(i+32,i+62)
					id3_version:= 1
					second_level_parse(temp_tit,false)
					second_level_parse(temp_art, true)
			elseif not has_id3 then
					has_id3:= false
					read_out_string:= "NOID3READ"
			end
			
			if  artist = void or title = void then
			minus_seperation
			end
			
			close
						
end
	
feature {NONE} artist_parse is
		-- find out the artist of the mp3file
	require
		file_has_art: has_art = true
	local
		pos,  i: INTEGER
		temp_string: STRING
	do
			pos:= read_out_string.substring_index("TPE1", 1)
			
			from
				temp_string:= read_out_string.substring (pos+4, pos+7)
				i:=1
			until
			i > read_out_string.count
			loop
				if
					possible_tags.has_substring(temp_string) and  temp_string.count = 4
				then
					second_level_parse(read_out_string.substring(pos+4, pos+2+i), true)
					i:= read_out_string.count+1
				elseif temp_string.count = 0 then
					second_level_parse(read_out_string.substring(pos+4, read_out_string.count), true)
				 	i:= read_out_string.count+1			
				else
					temp_string:=read_out_string.substring(pos+4+i,pos+7+i)
					i:=i+1
				end
			end	
		end
		
	
feature {NONE}title_parse is
		-- find out the title of the mp3file
require
mp3_file_has_title: has_tit = true
	local
			
		pos,  i: INTEGER
		temp_string: STRING
		do
			
				pos:= read_out_string.substring_index("TIT2", 1)
			
			from
				temp_string:= read_out_string.substring (pos+4, pos+7)
				i:=1
			until
			i > read_out_string.count
			loop
				if
					possible_tags.has_substring(temp_string) and  temp_string.count = 4
				then
					second_level_parse(read_out_string.substring(pos+4, pos+2 +i), false)
					i:= read_out_string.count+1
				elseif temp_string.count = 0 then
					second_level_parse(read_out_string.substring(pos+4, read_out_string.count), false)
				 i:= read_out_string.count+1			
				else
					temp_string:=read_out_string.substring(pos+4+i,pos+7+i)
					i:=i+1
			
				end
				
			end	

		end

feature minus_seperation is
		-- divides file_name string into two parts, middlepoint is the minus
local
	miex: BOOLEAN
	tmp_file_name: STRING
	index: INTEGER
	
			do
				tmp_file_name:= file_name
				miex:= tmp_file_name.has('-') 
				index:= tmp_file_name.substring_index ("-", 1)
				if miex and tmp_file_name.item(index+1).code = 32 and tmp_file_name.item(index-1).code = 32 then
					if title = void then
					title:= tmp_file_name.substring(index+1,tmp_file_name.count-4)
					end
					if artist = void  then	
					artist:= tmp_file_name.substring(1,index - 1)
					end
				end
				
			end
	
		



feature {NONE} second_level_parse(input: STRING is_art: BOOLEAN) is
		-- feature is called to sort out unprintable chars
require
input_not_void: input /= void
		-- feature is calledto called to eleminate unprintable chars
		local 
		j: INTEGER
		new_string: STRING
		ch: CHARACTER
		found: BOOLEAN
		do
			io.print(input)
			io.put_new_line
			io.print(is_art.out)
			io.put_new_line
			io.print(id3_version.out)
			io.put_new_line
			
							from
								j:=1	
	
							until
							  j > input.count
							loop

									ch:= input.item(j)
													
									if 	found  then
												
											if  ch.code < 32 or ch.code >122 then	
														if is_art then
															artist:= input.substring(1,j)
														else
															title:= input.substring(1,j)
														end --is_art? end
														j:= input.count+1
														
										 	elseif j = input.count then
														if is_art then
															artist:= input.substring(1,j)
														else
															title:= input.substring(1,j)
														end	--is_art? end
														j:= input.count+1							
	
											else	
													j:=j+1											
											end	--found? end

									elseif 32 < ch.code and ch.code <= 122 then
											j:=j+1							
											found:= true
									else 
											new_string:= input.substring(j+1, input.count)
											second_level_parse(new_string, is_art)
											j:=input.count+1
								end --main-if-end
							end		--loop-end

io.put_new_line
		end							--feature-end
		
		


invariant
		possible_tags_not_empty: possible_tags /= void and then not possible_tags.is_empty
	end
