indexing
	description: "Objects that display a dialog of the selected files"
	author: "Timon Hertli"
	date: "$Date$"
	revision: "$Revision$"

class
	DISPLAY_FILES_DIALOG

inherit
	EV_DIALOG
		redefine
			initialize
		end

create
	default_create

feature
	initialize is
			-- Initialize Dialog
		do
			Precursor
			create list
			extend (list)
			set_title (title_text)
			implementation.enable_closeable
			implementation.enable_user_resize
			set_size (800,500)
			close_request_actions.extend (agent close_dialog)
			show_actions.extend (agent initialize_list)
		end
	
feature {NONE} -- Events

	close_dialog is
			-- Close dialog
		do
			destroy
		end
		
	initialize_list is
			-- Initialize list to names
		do
			list.wipe_out
			if names /= Void then
				from names.start until names.after loop
					list.extend (create {EV_LIST_ITEM}.make_with_text (names.item))
					names.forth
				end	
			end
		end
		
feature -- Access
	set_names (a_list: LIST[STRING]) is
			-- Set names to display
		do
			names := a_list
		ensure
			names_set: names = a_list
		end
		
	names: LIST[STRING]
	
feature {NONE} -- Widgets

	list: EV_LIST
	
feature {NONE} -- Constants	
	title_text: STRING is "Ausgewhlte Files (TEST)"

end -- class DISPLAY_FILES_DIALOG
