indexing
	description: "Objects that display a dialog from whom the user can choose input paths and an output path"
	author: "Timon Hertli"
	date: "$Date$"
	revision: "$Revision$"

class
	DIRECTORY_DIALOG

inherit
	EV_DIALOG
		redefine
			initialize
		end
		
	FILE_SYSTEM_STRUCTURE_CONVERTER
		export {NONE}
			all
		undefine
			default_create, copy
		end

create
	default_create

feature
	initialize is
			-- Initialize Dialog
		do
			Precursor
			create big_box
			create box
			create tree
			create add_button.make_with_text_and_action (">", agent add_button_click)
			create list
			create right_box
			create bottom_button_box
			create medium_box
			create output_path.make_with_text (output_path_text) 
			create set_output_button.make_with_text_and_action (">", agent set_output_button_click)
			create delete_all_button.make_with_text_and_action ("Alles lschen", agent list.wipe_out)
			create delete_selected_button.make_with_text_and_action ("Ausgewhlte lschen",
				agent delete_selected_click)
			create cancel_button.make_with_text_and_action ("Abbrechen", agent close_dialog (false))
			create ok_button.make_with_text_and_action ("OK", agent close_dialog (true))
			extend (big_box)
			big_box.extend (box)
			big_box.extend (bottom_button_box)
			big_box.set_padding (5)
			box.extend (tree)
			box.extend (medium_box)
			box.extend (right_box)
			
			medium_box.extend (add_button)
			medium_box.extend (set_output_button)
			box.set_padding (5) 
			
			right_box.extend (list)
			right_box.extend (output_path)
			
			list.enable_multiple_selection
			medium_box.set_minimum_width (30) 
			set_output_button.set_minimum_height (20)
			box.disable_item_expand (medium_box)
			medium_box.disable_item_expand (set_output_button)
			output_path.set_minimum_height (20)
			right_box.disable_item_expand (output_path)
			
			bottom_button_box.extend (ok_button)
			bottom_button_box.extend (cancel_button)
			bottom_button_box.extend (delete_all_button)
			bottom_button_box.extend (delete_selected_button)
			
			bottom_button_box.set_minimum_height (30)
			bottom_button_box.set_padding (2) 
			bottom_button_box.do_all (agent bottom_button_box.disable_item_expand)
			bottom_button_box.do_all (agent {EV_WIDGET}.set_minimum_width (120))
			big_box.disable_item_expand (bottom_button_box) 
			
			set_title (title_text)
			implementation.enable_closeable
			implementation.enable_user_resize
			set_size (800,500)
			close_request_actions.extend (agent close_dialog (false))
			show_actions.extend (agent create_tree)
		end

feature {NONE}
	--Events

	create_tree is
			-- Create the tree
		do
			create_file_system_tree (tree, root_directory)
		end
		

	add_button_click is
			-- Add tree node to list
		do
			if tree.selected_item /= Void then
				add_node_to_list (tree.selected_item)
			end
		end
		
	set_output_button_click is
			-- Set output path
		do
			if tree.selected_item /= Void then
				output_path.set_text (output_path_text + get_directory_from_node (tree.selected_item))
				output := get_directory_from_node (tree.selected_item)
			end
		end
		
		
	add_node_to_list (node: EV_TREE_NODE) is
	 		-- Add current node to list
	 	require
	 		node_not_void: node /= Void
	 	do
	 		if not only_leaf_directories or node.count = 0 then
		 		list.extend (create {EV_LIST_ITEM}.make_with_text (get_directory_from_node (node)))
		 	end
	 		node.do_all (agent add_node_to_list)
	 	end

	close_dialog (continue: BOOLEAN) is
			-- Close dialog
		do
			if continue then
				create input.make (list.count)
				list.linear_representation.do_all (agent extend_input)
			else
				input := Void
			end
			destroy
		end
		
	extend_input (list_item: EV_LIST_ITEM) is
			-- Extends input
		do
			input.extend (list_item.text)
		end
		
	delete_selected_click is
			-- Delete selected item
		do
			list.selected_items.do_all (agent delete_list_item)
		end
		
	delete_list_item (list_item: EV_LIST_ITEM) is
			-- Delete list item
		do
			list.prune (list_item)	
		end

feature
	-- Access
	
	only_leaf_directories: BOOLEAN -- Only save leaf directories
	set_only_leaf_directories (a: BOOLEAN) is
			-- Set only leaf directories
		do
			only_leaf_directories := a
		end
		
	root_directory: STRING -- The root directory
	set_root_directory (a: STRING) is
			-- Set root directory
		do
			root_directory := a.twin
			root_directory.replace_substring_all ("\", "/") 
		end
		
		
	output: STRING
	input: ARRAYED_LIST [STRING]
	input_filenames: LINKED_LIST [STRING] is
			-- Names of the input files
		do
			create Result.make
			input.do_all (agent add_filenames_from_directory (Result, ?))
		end
		

feature {NONE}
	-- Widgets

	big_box: EV_VERTICAL_BOX
	box: EV_HORIZONTAL_BOX
	bottom_button_box: EV_HORIZONTAL_BOX
	right_box: EV_VERTICAL_BOX
	medium_box: EV_VERTICAL_BOX
	tree: EV_TREE
	add_button: EV_BUTTON
	set_output_button: EV_BUTTON
	delete_all_button: EV_BUTTON
	delete_selected_button: EV_BUTTON
	ok_button: EV_BUTTON
	cancel_button: EV_BUTTON
	list: EV_LIST
	output_path: EV_TEXT_FIELD
	
	-- Constants

	output_path_text: STRING is "Ausgabepfad : "
	title_text: STRING is "Directories auswhlen"

end -- class TREE_DIALOG
