indexing
	description: "Objects that ..."
	author: ""
	date: "$Date$"
	revision: "$Revision$"

class
	DIRECTORY_CLASS

	inherit
		ANY
	redefine
		out
	end

create
	make

feature -- Access
	size: REAL -- in mb
	caption: STRING
	path: STRING
	file_system: KL_WINDOWS_FILE_SYSTEM
		
feature -- initialization
	make ( a_path: STRING ) is
		require
			a_path_exists: a_path /= void and then ( a_path.count > 0 ) 
		local
			path_split_list: LIST[STRING]
		do
			path := a_path
			size := get_size ( path ).rounded
			path_split_list := path.split ( '/' )
			caption := path_split_list.last
		ensure 
			path_set: path = a_path
			caption_set: caption /=void and then caption.count > 0
		end

feature -- Output
	out : STRING is
		do
			create Result.make_empty
			Result := caption + ": " + path + ", size: " + size.out
		end
		
feature {DIRECTORY_CLASS} -- Private functions
	get_size ( a_path : STRING ) : REAL is
		require
			a_path_exists: a_path /= void and then ( a_path.count > 0 ) 
		local 
			a_kl_directory: KL_DIRECTORY
			a_file: KL_WINDOWS_INPUT_FILE
			i: INTEGER
		do
			Result := 0
			create a_kl_directory.make ( path )
			
			--  first get recursively size of all the directories
			from
				i := 1
			until 
				i > a_kl_directory.directory_names.count
			loop
				Result := Result + get_size ( a_path + "\" + a_kl_directory.directory_names @ ( i ) )
				i := i + 1
			end
			
			--  add size of remaining files
			from
				i := 1
			until 
				i > a_kl_directory.filenames.count
			loop
				create a_file.make ( a_path + "\" + a_kl_directory.filenames @ ( i ) )
				Result := Result + a_file.count
				i := i + 1
			end
			
			Result := Result / ( 1024 * 1024 ) -- put size in mb
		ensure 
			Result_exists: Result /= void 
			Result_not_negative: Result >= 0
		end

invariant
	caption_exists: caption /= void
	path_exists: path /= void and then path.count > 0
	
end -- class DIRECOTRY_CLASS
