indexing
	description: "Objects that should represent a shelf with CDs"
	author: "Marko Ristin"
	date: "$Date$"
	revision: "$Revision$"

class
	CD_COLLECTION



	inherit
		LINKED_LIST[CD_CLASS]
	
create
	make, with_number_of_items

feature -- Initialization
	with_number_of_items ( a_number: INTEGER; a_medium_size: REAL ) is
		-- create a CD collection with given number of empty CDs and medium size (in megabytes)
		require
			a_number_is_positive: a_number > 0
			a_medium_size_positive: a_medium_size > 0
		local
			i: INTEGER
			a_cd : CD_CLASS
		do
			from
				i := 1
			until
				i > a_number
			loop
				create a_cd.make ( a_medium_size )
				extend ( a_cd )
				i := i + 1
			end
		ensure
			items_set: count = a_number
		end

feature -- Edit
	sort_after_number_of_directories is
		-- sort all CDs in the collection on criterium of number of its directories. 
		-- The cd with the least directories should be first and one with  the most last.
		local
			i: integer
			j: integer
			cd_temp: CD_CLASS
		do
			from
				i := count
			until
				i <= 2
			loop
				from
					j := 1
				until 
					j = i
				loop
					if ( i_th ( j ).directory_collection.count < i_th ( j + 1 ).directory_collection.count ) then
						-- swap current @ ( j ) and current @ ( j + 1 )
						
						cd_temp := i_th ( j + 1 )
						put_i_th ( i_th ( j ), j + 1 )		-- current @ ( j + 1 ) = current @ ( j )
						put_i_th ( cd_temp, j )			-- current @ ( j ) = cd_temp = old current @ ( j + 1 )
					end
					j := j + 1
				end
				i := i - 1
			end
		end




end -- class CD_COLLECTION
