indexing
	description: "objects of type CD_CLASS should represent CDs on which we sort given directories"
	author: "Marko Ristin"
	date: "$Date$"
	revision: "$Revision$"

class
	CD_CLASS

	inherit
		ANY
	redefine
		out
	end

create 
	make

feature -- Access
	directory_collection: DIRECTORY_COLLECTION	-- Directories set on CD
	free_space: REAL -- Free space on CD, in megabytes
	medium_size: REAL -- Medium size (total size of CD), in megabytes

feature -- Initialization
	make ( a_medium_size: REAL ) is
		-- create a cd and set its medium size
		require
			a_medium_size_positive: a_medium_size > 0
		do
			medium_size := a_medium_size
			free_space := medium_size
			create directory_collection.make
		ensure
			medium_size_set: medium_size = a_medium_size
		end

feature -- Edit
	add_directory ( a_directory : DIRECTORY_CLASS ) is
		-- add directory to the cd
		require
			sufficient_free_space: a_directory.size <= free_space
		do
			directory_collection.extend ( a_directory )
			free_space := free_space - a_directory.size
		ensure
			free_space_correctly_calculated: free_space = old free_space - a_directory.size
		end
	
feature -- Output
	out : STRING is 
		-- result is name of the cd; in this stadium of development only a constant string "CD"	
		do
			create Result.make_empty
			Result := "CD"
		ensure then
			Result_not_void: Result /= void
		end

invariant
	free_space_smaller_or_equal_to_medium: free_space <= medium_size

end -- class CD_CLASS
