indexing
	description: "Objects that display a sorted collection of mp3-files"
	author: "Timon Hertli"
	date: "$Date$"
	revision: "$Revision$"

class
	DISPLAY_SORTED_DIALOG

inherit
	EV_DIALOG
		redefine
			initialize
		end

create
	default_create

feature
	initialize is
			-- Initialize Dialog
		do
			Precursor
			create box
			create button_box
			create tree
			create ok_button.make_with_text_and_action ("Speichern", agent close_dialog(true))
			create cancel_button.make_with_text_and_action ("Abbrechen", agent close_dialog(false))
			extend (box)
			box.extend (tree)
			box.extend (button_box)
			button_box.extend (ok_button)
			button_box.extend (cancel_button)
			box.disable_item_expand (button_box)
			set_title (title_text)
			implementation.enable_closeable
			implementation.enable_user_resize
			set_size (800,500)
			close_request_actions.extend (agent close_dialog(false))
			show_actions.extend (agent initialize_tree)
		end
	
feature {NONE} -- Events

	close_dialog (save: BOOLEAN) is
			-- Close dialog
		do
			is_save := save
			destroy
		end
		
	initialize_tree is
			-- Initialize tree
		local
			root: MY_TREE_NODE
		do
			create root
			if output /= Void then
				root.set_text (output)
			end
			tree.extend (root)
			if directories.count /= 0 then
				directories.do_all (agent add_directory_to_node (?,root))
			end
		end
		
	add_directory_to_node (dir: MP3_DIRECTORY[MP3_FILE]; node: MY_TREE_NODE) is
			-- Add directory to a node
		local
			new_node: MY_TREE_NODE
		do
			create new_node
			new_node.set_text (dir.name)
			node.extend (new_node)
			if dir.count /= 0 then
				dir.do_all (agent add_file_to_node (?,new_node))
			end
		end
		
	add_file_to_node (file: MP3_FILE; node: MY_TREE_NODE) is
			-- Add file to a node
		local
			new_node: MY_TREE_NODE
		do
			create new_node
			new_node.set_text (file.new_name)
			node.extend (new_node)
		end
		
feature -- Access
	set_directories_and_output (a_list: LIST[MP3_DIRECTORY[MP3_FILE]]; a_output: STRING) is
			-- Set names to display
		do
			directories := a_list
			output := a_output
		ensure
			directories_set: directories = a_list
		end
		
	directories: LIST[MP3_DIRECTORY[MP3_FILE]]
	output: STRING
	
	is_save: BOOLEAN
	
	
feature {NONE} -- Widgets

	box: EV_VERTICAL_BOX
	button_box: EV_HORIZONTAL_BOX
	ok_button: EV_BUTTON
	cancel_button: EV_BUTTON
	tree: EV_TREE
	
feature {NONE} -- Constants	
	title_text: STRING is "Sortierte Files"

end -- class DISPLAY_SORTED_DIALOG
