indexing
	description	: "Main window for this application"
	author		: "Timon Hertli"
	date		: "$Date: 2005/1/7 18:8:41 $"
	revision	: "1.0.0"

class
	MAIN_WINDOW

inherit
	EV_TITLED_WINDOW
		redefine
			initialize,
			is_in_default_state
		end

create
	default_create

feature {NONE} -- Initialization

	initialize is
			-- Build the interface for this window.
		do
			Precursor
			create big_container
			create main_container
			create file_sort_button.make_with_text_and_action (file_sort_text, agent file_sort_event)
			create cd_distribute_button.make_with_text_and_action (cd_distribute_text, agent cd_distribute_event)
			create root_directory.make_with_text ("ALL")
			create root_directory_label.make_with_text ("Root-Directory: ")
			create lower_container
			extend (big_container)
			big_container.extend (main_container)
			main_container.extend (file_sort_button)
			main_container.extend (cd_distribute_button)
			big_container.extend (lower_container)
			lower_container.extend (root_directory_label)
			lower_container.extend (root_directory)
			lower_container.disable_item_expand (root_directory_label)
			file_sort_button.set_minimum_width (200) 
			cd_distribute_button.set_minimum_width (200) 
			file_sort_button.set_minimum_height (50) 
			cd_distribute_button.set_minimum_height (50) 
			main_container.disable_item_expand (file_sort_button)
			main_container.disable_item_expand (cd_distribute_button)
			
			set_title (Window_title)
--			set_size (Window_width, Window_height)
			disable_user_resize
			close_request_actions.extend (agent kill_application)
		end

	is_in_default_state: BOOLEAN is true

feature {NONE} -- Event handling

	file_sort_event is
			-- Sort files
		local
			dir_dialog: DIRECTORY_DIALOG
			file_dialog: DISPLAY_FILES_DIALOG
			sort_dialog: DISPLAY_SORTED_DIALOG
			sorter: MP3_SORT
		do
			create dir_dialog		
			dir_dialog.set_only_leaf_directories (False)
			dir_dialog.set_root_directory (root_directory.text)
			dir_dialog.show_modal_to_window (Current)
			if dir_dialog.input /= Void and dir_dialog.input.count > 0 then
				create file_dialog
				file_dialog.set_names (dir_dialog.input_filenames)
				file_dialog.show_modal_to_window (Current)
				create sorter.make_with_files (dir_dialog.input_filenames)
				sorter.sort
				create sort_dialog
				sort_dialog.set_directories_and_output (sorter.sorted, dir_dialog.output)
				sort_dialog.show_modal_to_window (Current)
				if dir_dialog.output /= Void and sort_dialog.is_save then
					sorter.move (dir_dialog.output.substring (1, dir_dialog.output.count - 1), true) 
				end
			end
			
		end
		
	cd_distribute_event is
			-- Distribute directories to cds
		local
			dir_dialog: DIRECTORY_DIALOG
			path_distributer: PATH_DISTRIBUTER
			distr_dialog: DISPLAY_DISTRIBUTED_DIALOG
		do
			create dir_dialog
			dir_dialog.set_only_leaf_directories (True)
			dir_dialog.set_root_directory (root_directory.text)
			dir_dialog.show_modal_to_window (Current)
			if dir_dialog.input /= Void and dir_dialog.input.count > 0 then
				from dir_dialog.input.start
				until
					dir_dialog.input.after
				loop
					dir_dialog.input.replace (dir_dialog.input.item.substring (1,dir_dialog.input.item.count-1))
					dir_dialog.input.forth
				end
				create path_distributer.make (dir_dialog.input, 650.0)
				create distr_dialog
				distr_dialog.set_collection (path_distributer.sort) 
				distr_dialog.show_modal_to_window (Current) 
			end
		end
		

	start_directory_dialog is
			-- Start directory dialig
		do
				(create {DIRECTORY_DIALOG}).show_modal_to_window (Current)
		end
		

feature {NONE} -- Widgets

	big_container: EV_VERTICAL_BOX
	main_container: EV_HORIZONTAL_BOX
	lower_container: EV_HORIZONTAL_BOX
	file_sort_button: EV_BUTTON
	cd_distribute_button: EV_BUTTON
	root_directory: EV_TEXT_FIELD
	root_directory_label: EV_LABEL

feature {NONE} --Implementation
		
	kill_application is
			-- Kill application
		do
			destroy;
			(create {EV_ENVIRONMENT}).application.destroy
		end
		

feature {NONE} -- Implementation / Constants

	file_sort_text: STRING is "MP3s sortieren"
	
	cd_distribute_text: STRING is "Verzeichnisse auf CD verteilen"

	Window_title: STRING is "CD-Sort"
			-- Title of the window.

--	Window_width: INTEGER is 500
			-- Initial width for this window.

--	Window_height: INTEGER is 400
			-- Initial height for this window.

end -- class MAIN_WINDOW
