indexing
	description: "Objects that enable displaying the file-system-structure as a tree"
	author: "Timon Hertli"
	date: "$Date$"
	revision: "$Revision$"

class
	FILE_SYSTEM_STRUCTURE_CONVERTER

feature
	add_filenames_from_directory (list: LIST[STRING]; directory_name: STRING) is
			-- Adds the filenames from a directory to a list
		require
			list_not_void: list /= Void
			directory_name_not_void: directory_name /= Void
		local
			directory: DIRECTORY
			dir_entries: ARRAYED_LIST[STRING]
		do
			if (directory_name @ directory_name.count) /= '/' then
				directory_name.append ("/") 
			end
			create directory.make_open_read (directory_name) 
			dir_entries := directory.linear_representation
			from dir_entries.start until dir_entries.after loop
				if not (create {DIRECTORY}.make_open_read(directory_name + dir_entries.item)).exists then
					list.extend (directory_name + dir_entries.item)
				end
				dir_entries.forth
			end
		end

	get_directory_from_node (node: EV_TREE_NODE): STRING is
			-- Directory from a node
		require
			node /= Void
			node_has_string: node.data.same_type ("") 
		do
			if node /= Void then
				Result ?= node.data
			end
		ensure
			result_not_void: result /= Void
		end
		

	create_file_system_tree (the_tree: EV_TREE; root_directory: STRING) is
			-- Create the file-system-tree
		require
			tree_not_void: the_tree /= Void
			root_directory_not_void: root_directory /= Void
		local
			drive: CHARACTER
			node: MY_TREE_NODE
		do
			if equal(root_directory, "ALL") then
				if (create {PLATFORM}).is_windows then
					from drive := 'A' until drive > 'Z' loop
						node := drive_tree (drive.out + ":")
						if node /= Void then
							the_tree.extend (node)
						end
						drive := drive.next
					end
				else
					node := drive_tree ("")
					if node /= Void then
						the_tree.extend (node)
					end
				end
			elseif (create {DIRECTORY}.make_open_read (root_directory)).exists then
				node := sub_file_system_tree (root_directory)
				node.set_text (root_directory)
				node.set_data (root_directory)
				if node /= Void then
					the_tree.extend (node)
				end
			end
		end
	
	drive_tree (drive: STRING): MY_TREE_NODE is
			-- Create a tree of a drive (drive="" for / as root)
		require
			drive_not_void: drive /= Void
		do
			if (create {DIRECTORY}.make_open_read (drive + "/")).exists then				
				Result := sub_file_system_tree (drive)
				Result.set_text (drive) 
				Result.set_data ((drive + "/").twin)
			end
		end
		
	sub_file_system_tree (current_path: STRING): MY_TREE_NODE is
			-- Tree of sub-file-system
		require
			current_path_not_void: current_path /= Void
		local
			node: MY_TREE_NODE
			directory: DIRECTORY
			dir_entries: ARRAYED_LIST[STRING]
		do
			create {MY_TREE_NODE}Result
			create directory.make_open_read (current_path+"/")
			dir_entries := directory.linear_representation
			from dir_entries.start until dir_entries.after loop
				if not equal (dir_entries.item, ".") and not equal (dir_entries.item, "..") 
				 and (create {DIRECTORY}.make_open_read (current_path + "/" + dir_entries.item)).exists then
					node := sub_file_system_tree (current_path + "/" + dir_entries.item)
					node.set_text (dir_entries.item)
					node.set_data ((current_path + "/" + dir_entries.item + "/").twin)
					Result.extend (node)
				end
				dir_entries.forth
			end	
		ensure
			Result_not_void: Result /= Void
		end

end -- class FILE_SYSTEM_STRUCTURE
