indexing
	description: "Objects that display a dialog how the directories were distributed to CDs"
	author: "Timon Hertli"
	date: "$Date$"
	revision: "$Revision$"

class
	DISPLAY_DISTRIBUTED_DIALOG

inherit
	EV_DIALOG
		redefine
			initialize
		end

create
	default_create

feature
	initialize is
			-- Initialize Dialog
		do
			Precursor
			create tree
			extend (tree)
			set_title (title_text)
			implementation.enable_closeable
			implementation.enable_user_resize
			set_size (800,500)
			close_request_actions.extend (agent close_dialog)
			show_actions.extend (agent initialize_tree)
		end
	
feature {NONE} -- Events

	close_dialog is
			-- Close dialog
		do
			destroy
		end
		
	initialize_tree is
			-- Initialize the tree
		local
			root: MY_TREE_NODE
		do
			create root
			root.set_text ("CDs:")
			if collection /= Void then
				collection.do_all (agent add_cd_to_node (?, root))
			end
			tree.extend (root)
		end
		
	cd_number: INTEGER
	
	add_cd_to_node (cd: CD_CLASS; node: MY_TREE_NODE) is
			-- Add a cd to a node
		local
			new_node: MY_TREE_NODE
		do
			create new_node
			node.extend (new_node)
			cd_number := cd_number + 1
			new_node.set_text (cd.out + " " + cd_number.out)
			cd.directory_collection.do_all (agent add_directory_to_node (?,new_node))
		end
		
	add_directory_to_node (dir: DIRECTORY_CLASS; node: MY_TREE_NODE) is
			-- Add a directory to a node
		local
			new_node: MY_TREE_NODE
		do
			create new_node
			node.extend (new_node)
			new_node.set_text (dir.out)
		end
		
		
feature -- Access
	set_collection (a_collection: CD_COLLECTION) is
			-- Set names to display
		do
			collection := a_collection
		ensure
			collectlin_set: collection = a_collection
		end
		
	collection: CD_COLLECTION
	
feature {NONE} -- Widgets

	tree: EV_TREE
	
feature {NONE} -- Constants	
	title_text: STRING is "CD-bersicht"

end -- class DISPLAY_SORTED_DIALOG
