indexing
	description: "Objects that represent directories which have to be sorted"
	author: "Marko Ristin"
	date: "$Date$"
	revision: "$Revision$"

class
	DIRECTORY_COLLECTION

	inherit
		LINKED_LIST[DIRECTORY_CLASS]
	

create
	make, from_path_list

feature -- Initialization
	from_path_list ( a_path_list: LIST[STRING] ) is
		-- loads directories from path,
		-- non-existent directories will be ignored
		require
			a_path_list_exists: a_path_list /= void
		local
			a_directory: DIRECTORY_CLASS
		do
			-- check which paths exist and remove the non-existent:
			check_path_list ( a_path_list )				
			from
				a_path_list.start
			until
				a_path_list.after
			loop
				create a_directory.make ( a_path_list.item )
				extend ( a_directory )
				a_path_list.forth
			end
		end

feature -- Access
	sum_of_sizes : REAL is
		-- returns sum of sizes of all directories
		do
			from
				start
			until
				after
			loop
				result := result + item.size
				forth
			end
		ensure
			result_not_negative: result >= 0
		end

	find_next_directory_to_size ( a_size: REAL ) : INTEGER is
		-- finds directory which size is next to a given size;
		-- if there's a such directory, item will be set on it and result is its index;
		-- if index = 0 then all the directories are bigger than the given size.
		require
			a_size_exists: a_size /= void
		local
			minimum_delta: REAL
		do
			from
				start
				Result:= 0
				if( not after ) then 
					minimum_delta := a_size - item.size 
					if( minimum_delta >= 0 ) then 
						Result := index 
					end
				end
			until
				after
			loop
				if ( a_size - item.size < minimum_delta and a_size - item.size >= 0 ) then
					Result := index
					minimum_delta := a_size - item.size
				end
				forth
			end
			-- if first item is bigger than a_size, minimum_delta will be negative,
			-- hence there's no appropriate directory
			if ( minimum_delta < 0 ) then
				Result := 0
			else
				go_i_th ( Result )
			end
			ensure
				item_pointer_set: Result = 0 or index = Result
				Result_not_negative: Result >= 0
		end
		
	exclude_bigger_than ( a_size: REAL ) : DIRECTORY_COLLECTION is
		-- excludes directories bigger than a_size;
		-- return a directory collection of returned directories
		require
			a_size_positive: a_size > 0
		do
			create Result.make
			from
				start
			until
				after
			loop
				if ( item.size > a_size ) then
					Result.extend ( item )
					remove
					back			-- cursor points on the item on the left of the removed object
				end
				forth
			end
		end

feature {DIRECTORY_COLLECTION}-- Intern functions
	check_path_list ( a_path_list : LIST[STRING] ) is
		-- check if paths exist and removes those who don't
		require
			a_path_list_exists: a_path_list /= void
		local
		file_system: KL_WINDOWS_FILE_SYSTEM 
		do
			create file_system.make
			from 
				a_path_list.start
			until 
				a_path_list.after
			loop
				if ( not file_system.directory_exists ( a_path_list.item ) ) then
					a_path_list.remove
					a_path_list.back
				end
				a_path_list.forth
			end
		end

end -- class DIRECTORY_COLLECTION
