indexing
	description: "Zustndig zum erstellen von Fenstern und features zur Grafikausgabe"
	author: "Bucher Peter"
	date: "$20.1.05$"
	revision: "$1.0$"

class
	DISPLAYER
create
	CreateWindow
		
feature -- Window
	CreateWindow (x : INTEGER; y : INTEGER; fullscreen : BOOLEAN) is
		-- ffnet ein fenster mit den gegebnen Optionen
			require
				 esdl_void: esdl = void
			do
				width := x
				height := y
				fs := fullscreen
				create esdl.make
				esdl.set_video_surface_width (width)
				esdl.set_video_surface_height (height)
				esdl.set_video_bpp (32) -- Bits per pixel default
				esdl.set_fullscreen (fs)
				esdl.initialize_video_surface
				screen := esdl.video_surface
				
				create font.loadfont ("./data/arial256.gif")
			end
			
	DestroyWindow is
		-- Schliesst das Erstellte Fenster
			require
				esdl_notvoid: esdl /= void
			do
				esdl.quit
				esdl := void
			ensure
				esdl_void: esdl = void
			end
	
	GetWindowWidth : INTEGER is
		-- Gibt die Breite des Fensters zurck
			do
				Result := width
			end
	
	GetWindowHeight : INTEGER is
		-- Gibt die Hhe des Fensters zurck
			do
				Result := height
			end
	
	GetFullscreen : BOOLEAN is
		-- Gibt true wenn Fullscreen aktiviert
			do
				Result := fs
			end
		
			
feature -- Grafik
	DrawObject (obj : GRAPHIC_OBJECT; x : INTEGER; y : INTEGER) is
		-- Zeichnet ein Grafikobjekt das zuvor erstellt wurde damit die Grafik nicht jedesmal aus einer Datei gelesen wird
			require
				obj_not_void: obj /= void
			do
				screen.blit_surface (obj.bild, x, y)
			end
			
	DrawObjectFromFile (file : STRING; x :INTEGER; y : INTEGER) is
		-- Liest ein Bild aus einer Datei und stellt dies an position x,y dar.
			require
				file_not_void: file /= void
				file_not_empty: not(file.is_empty)
			local
				bild: ESDL_SURFACE
			do
				create bild.make_from_image (file)
				screen.blit_surface (bild, x, y)
			end
			
	Redraw is
		-- Zeichnet screen_surface auf den Bildschirm
			require
				screen_not_void: screen /= void
				screen_exists: screen.exists
			do
				screen.redraw
			end
	ClearScreen is
		-- Lscht Bildschirm
			require
				screen_not_void: screen /= void
				screen_exists: screen.exists
			do
				screen.clear
			end
	ClearScreenAndFillColor (r : INTEGER; g	 : INTEGER; b : INTEGER) is
		-- Lscht den Bildschirm und fllt ihn mit einer bestimmten Farbe
			require
				screen_not_void: screen /= void
				screen_exists: screen.exists
			local
				color : ESDL_COLOR
			do
				create color.make
				color.set_red (r)
				color.set_green (g)
				color.set_blue (b)
				screen.clear
				screen.fill (color)
			end
			
		
		
	
feature -- Schrift
	DrawString (text : STRING; x : INTEGER; y : INTEGER) is
		-- Gibt einen Text auf den Bildschirm aus, Die Standart-Schriftart wird in CreateWindow initialisiert.
			require
				font_not_void: font /= void
			do
				font.font.draw_string (text, screen, x, y)
			end
	
	DrawStringSpecialFont (text : STRING; x : INTEGER; y : INTEGER; sfont : FONT) is
		-- Gibt einen Text auf den Bildschirm aus, Die Schriftart muss im vornhinein initialisiert werden.
			require
				font_not_void: sfont /= void
			do
				sfont.font.draw_string (text, screen, x, y)
			end
		
feature -- Objects
	height : INTEGER
	width : INTEGER
	fs : BOOLEAN -- Fullscreen
	esdl : ESDL
	screen: ESDL_SURFACE
	
	font : FONT

end -- class DISPLAYER
