indexing
	description: "Darstellung und Behandlung des Spielfeldes"
	author: "Inderbitzin Simon & Bucher Peter"
	date: "$23.1.05$"
	revision: "$1.0$"

class
	BOARD

create
	make


feature -- Init

	make(width : INTEGER; height : INTEGER; XGew : INTEGER) is
			-- 
		do
			Breite := width
			Hoehe := height
			XGewinnt := XGew
			Game_over := false
			Aktueller_Spieler := 2

			create Window.createwindow (50*Breite + 140, 50*Hoehe + 50, false)
			create Stonered.loadimage ("./data/stein1.jpg")
			create Stoneblue.loadimage ("./data/stein2.jpg")
			create Stonenone.loadimage ("./data/leer.jpg")
			create Field.make (0, Breite*Hoehe)
			
			ShowBoard
			
		end
		
feature -- Moves
	PossibleMove(value:INTEGER):BOOLEAN is
			-- berprft ob dieser Move mglich ist.
		require
			not_too_small: value >= 0
			not_too_large: value < Breite
		do
			if Field.item (value) = 0 then
				Result := true
			else
				Result := false
			end
		end
		
	tellmove(value: MOVE) is
			-- Setzt den Stein an der korrekten Position im Array
		require
			not_too_small: value.getxpos >= 0
			not_too_large: value.getxpos < Breite
		local
			position_in_array : INTEGER
		do	
			position_in_array := GetPosition(value.getxpos)
			if position_in_array /= -1 then
				Aktueller_Spieler := (1 - (Aktueller_Spieler-1)) + 1 -- Erst den Spieler wechseln, nicht danach wechseln da sont CheckWin auf die falschen Steine prft
				Field.put (Aktueller_Spieler, position_in_array)
				
				Stein_Counter := Stein_Counter + 1
				Zuletzt_Gesetzter_Stein_X := value.getxpos
				Zuletzt_Gesetzter_Stein_Y := ( position_in_array - value.getxpos ) // Breite
			end
			
			ShowBoard
			Checkwinner
			
		end

feature {NONE}		
	GetPosition(value:INTEGER):INTEGER is
			-- Sucht das gltige Feld in dem Array, -1 falls nicht mglich
		require
			not_too_small: value >= 0
			not_too_large: value < Breite
		local
			counter:INTEGER
		do
			Result := -1  -- zum sichergehen, drfte nie gebraucht werden, da vorher mit PossibleMove geprft werden msste
			from
				counter := value
			until
				counter > Breite*Hoehe -1
			loop
				if Field.item (counter).is_equal (0) then
					Result := counter
				end
				counter := counter +Breite
			end	
		end

feature {NONE} -- Gewinner check
	
	CheckWinner is
			-- berprft, ob es einen Gewinner gibt, wenn ja, output z.b. "Player1"
		local
			tempstring : STRING
		do
			if (	CheckWinnerRecursion ( Zuletzt_Gesetzter_Stein_X, Zuletzt_Gesetzter_Stein_Y, -1, 0, Aktueller_Spieler, 0)
				+	CheckWinnerRecursion ( Zuletzt_Gesetzter_Stein_X, Zuletzt_Gesetzter_Stein_Y,  1, 0, Aktueller_Spieler, 0)
				+ 	1
				>= 	XGewinnt )
				or
				(	CheckWinnerRecursion ( Zuletzt_Gesetzter_Stein_X, Zuletzt_Gesetzter_Stein_Y,  0, -1, Aktueller_Spieler, 0)
				+	CheckWinnerRecursion ( Zuletzt_Gesetzter_Stein_X, Zuletzt_Gesetzter_Stein_Y,  0,  1, Aktueller_Spieler, 0)
				+ 	1
				>= 	XGewinnt )
				or
				(	CheckWinnerRecursion ( Zuletzt_Gesetzter_Stein_X, Zuletzt_Gesetzter_Stein_Y, -1, -1, Aktueller_Spieler, 0)
				+	CheckWinnerRecursion ( Zuletzt_Gesetzter_Stein_X, Zuletzt_Gesetzter_Stein_Y,  1,  1, Aktueller_Spieler, 0)
				+ 	1
				>= 	XGewinnt )
				or
				(	CheckWinnerRecursion ( Zuletzt_Gesetzter_Stein_X, Zuletzt_Gesetzter_Stein_Y, -1,  1, Aktueller_Spieler, 0)
				+	CheckWinnerRecursion ( Zuletzt_Gesetzter_Stein_X, Zuletzt_Gesetzter_Stein_Y,  1, -1, Aktueller_Spieler, 0)
				+ 	1
				>= 	XGewinnt )
			then
				tempstring := "Spieler "
				tempstring.append_integer (Aktueller_Spieler)
				tempstring.append_string (" hat Gewonnen!")
				showboard
				window.drawstring (tempstring , 50, 10)
				window.redraw
				Game_over := true
			elseif Stein_Counter = Breite * Hoehe then
				showboard
				window.drawstring ("Unentschieden!" , 50, 10)
				window.redraw
				Game_over := true
			end
		end
	
	CheckWinnerRecursion (	position_x : INTEGER; position_y : INTEGER; 
							move_x : INTEGER; move_y : INTEGER; 
							stone : INTEGER; counter : INTEGER			) : INTEGER 
			is
				-- Rekursive berprfung des Feldes anhand der x_move und y_move vektoren
		require
			move_x_y_not_zero: move_x /= 0 or move_y /= 0
			position_x: position_x < Breite and position_x >= 0
			position_y: position_y < Hoehe and position_y >= 0
		local
			tempcounter : INTEGER
		do
			if	(position_x + move_x) = -1 or (position_x + move_x) >= Breite or
				(position_y + move_y) = -1 or (position_y + move_y) >= Hoehe
			then
				Result := counter
			elseif Field @ (position_x + move_x + Breite * (position_y + move_y)) = stone then
				tempcounter := counter + 1
				Result := CheckWinnerRecursion (position_x + move_x, position_y + move_y, move_x, move_y, stone, tempcounter)
			else
				Result := counter
			end			
		end
		
feature -- Grafikausgabe

	ShowBoard() is
			-- Benutzt die Klass DISPLAYER um das Board visuell darzustellen.
		local
			x : INTEGER
			y : INTEGER
			str : STRING
		do
			window.clearscreen
			from
				y:= 0
			until
				y+1 > Hoehe
			loop
				from
					x := 0
				until
					x+1 > Breite
				loop
					if Field @ (x + Breite * y) = 0	then
						window.drawobject (Stonenone, x*Stonenone.get_width + 10, y*Stonenone.get_height+50)
					elseif Field @ (x + Breite * y) = 2	then
						window.drawobject (Stoneblue, x*Stonenone.get_width + 10, y*Stonenone.get_height+50)
					else
						window.drawobject (Stonered, x*Stonenone.get_width + 10, y*Stonenone.get_height+50)
					end
					x := x + 1
				end
				y := y + 1
			end
			window.drawstring ("Current", breite*Stonenone.get_width + 20 , 50)
			if aktueller_spieler = 2 then
				window.drawobject (Stonered, breite*Stonenone.get_width + 50 , 75)
			else
				window.drawobject (Stoneblue, breite*Stonenone.get_width + 50 , 75)
			end
			from
				x := 1
				create str.make_empty
			until
				x > breite
			loop
				str.clear_all
				str.append_integer (x)
				window.drawstring (str, x*Stonenone.get_width-30 , 20)
				x := x+1
			end
			window.redraw
		end
		
		
feature -- Information
	Is_gameover : BOOLEAN is
			-- gibt game_over zurck
		do
			Result := Game_over
		end
	
	Get_Width : INTEGER is
			-- gibt Breite zurck
		do
			Result := Breite
		end
	
	Get_Height : INTEGER is
			-- gibt Hoehe zurck
		do
			Result := Hoehe
		end
		

feature -- variable

	Field: ARRAY[INTEGER]
	Breite: INTEGER
	Hoehe: INTEGER
	XGewinnt: INTEGER -- anzahl steine in einer Reihe zum gewinnen
	
	Stonered: GRAPHIC_OBJECT
	Stoneblue: GRAPHIC_OBJECT
	Stonenone: GRAPHIC_OBJECT
	Window : DISPLAYER
	
	Aktueller_Spieler : INTEGER
	Zuletzt_Gesetzter_Stein_X : INTEGER -- Position die zuletzt belegt wurde, wird von CheckWinner gebraucht
	Zuletzt_Gesetzter_Stein_Y : INTEGER
	Stein_Counter : INTEGER -- wieviel steine auf dem Board sind, falls = Breite * Hoehe, ist das Board belegt, in CheckWinner gebraucht

	Game_over : BOOLEAN

end -- class BOARD