indexing
	description: "Class to open a server"
	author: "Matthias Geel"
	date: "1/23/05"
	revision: "Curd Bnziger, 1/27/05"

class
	OUR_SERVER

inherit

	NETWORK_SERVER
		redefine
			receive, received, close
		end

	STORABLE

create

	make_server

feature

	close is
		do
			
		end
		
	connections: LINKED_LIST [CONNECTION]

	message_in, message_out, received: MESSAGE
	
	max_to_poll: INTEGER

	poll: MEDIUM_POLLER
	
	text: STRING	

feature -- Nethunt specific

	estate_agent_connected: BOOLEAN
	
	flat_hunter_connected: BOOLEAN


feature -- Creation procedure

	make_server (port: INTEGER) is
		do
			make (port)
			text := ""

			io.new_line
			io.put_string("Created new server with port ");io.put_integer(port);io.put_string(". Waiting for players...")
			io.new_line
			io.new_line
			
			max_to_poll := 1
			create poll.make_read_only
			create connections.make
			connections.compare_objects
			in.set_non_blocking
			
			execute
		rescue
			create message_out.make
			message_out.set_text("Down")
			from
				connections.start
			until
				connections.after
			loop
				message_out.independent_store (connections.item.active_medium)
				connections.item.active_medium.close
				connections.forth
			end
			cleanup
		end


feature

	receive is
		do
			in.accept
			outflow ?= in.accepted
			if outflow /= Void then
				outflow.set_blocking
				new_client
			end
			initialize_for_polling
			poll.execute (max_to_poll, 15000)
		end
		
	initialize_for_polling is
		do
			from
				connections.start
			until
				connections.after
			loop
				connections.item.initialize
				connections.forth
			end
		end
		
	new_client is
		local
			new_connection: CONNECTION
		do
			if max_to_poll <= outflow.descriptor then
				max_to_poll := outflow.descriptor + 1
			end
			create new_connection.make (clone (outflow))
			connections.extend (new_connection)
			poll.put_read_command (new_connection)
		end



	process_message is
		local
			stop: BOOLEAN
				-- When we receive a message tagged "over", we remove connections
				-- from the list, so we want to exit from the loop...
			pos: INTEGER
		do
			from
				connections.start
			until
				connections.after or stop
			loop
				if connections.item.is_waiting then
					message_in ?= retrieved (connections.item.active_medium)
					if message_in.over then
						poll.remove_associated_read_command (connections.item.active_medium)
						connections.remove
						io.putstring ("Client disconnected.%N")
						stop := True
					elseif message_in.text.is_equal ("Estate Agent") then
						connections.item.set_client_name ("Estate Agent")
						estate_agent_connected := true
						io.putstring ("Estate Agent connected%N")
						
						pos := connections.index
						check_ready
						connections.go_i_th (pos)
					elseif message_in.text.is_equal ("Flat Hunter") then
						connections.item.set_client_name ("Flat Hunter")
						flat_hunter_connected := true
						io.putstring ("Flat Hunter connected%N")
						
						pos := connections.index
						check_ready
						connections.go_i_th (pos)
					else
						message_out := deep_clone (message_in)
						message_out.set_over (true)
						pos := connections.index
						broadcast
						connections.go_i_th (pos)
					end				
					
				end
				if not stop then
					connections.forth
				end		
				
			end
		end
		
	check_ready is
			-- 
		do
			if estate_agent_connected and flat_hunter_connected then
					create message_out.make
					message_out.set_text ("Players connected")
					message_out.set_over (true)
					broadcast
				end
		end
		
		
	
	broadcast is
		local
			client_name: STRING
		do
			client_name := clone (message_out.client_name)
			from
				connections.start
			until
				connections.after
			loop
				if not connections.item.client_name.is_equal (client_name) then
					message_out.independent_store (connections.item.active_medium)
				end
				connections.forth
			end
		end


end
