indexing
	description: 
		"[
			Shared displayer used by all the displayers that draw the city
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class SHARED_DISPLAYER

feature -- Access

	Drawable_objects: ARRAYED_LIST [DRAWABLE_OBJECT] is
			-- List of drawable objects
		once
			create Result.make (0)
		ensure
			Result_exists: Result /= Void
		end

feature -- Basic operations
		
	insert_list (a_list: LIST [DRAWABLE_OBJECT]) is
			-- Add `a_list' to drawable objects.
		require
			a_list_exists: a_list /= Void
			a_list_not_empty: not a_list.is_empty
		do
			execute_command (a_list, agent insert_command (?))
		end

	remove_list (a_list: LIST [DRAWABLE_OBJECT]) is
			-- Remove `a_list' from drawable objects.
		require
			a_list_exists: a_list /= Void
			a_list_not_empty: not a_list.is_empty
		do
			execute_command (a_list, agent remove_command (?))
		end

	put_list (a_old_list, a_new_list: LIST [DRAWABLE_OBJECT]) is
			-- Put `a_new_list' right after last element of `a_old_list'.
		require
			a_old_list_exists: a_old_list /= Void
			a_old_list_not_empty: not a_old_list.is_empty
			a_new_list_exists: a_new_list /= Void
			a_new_list_not_empty: not a_new_list.is_empty
		do
			Drawable_objects.start
			Drawable_objects.search (a_old_list.last)
			if not Drawable_objects.after then
				execute_command (a_new_list, agent Drawable_objects.put_right (?))			
			end
		end
		
	insert_command (an_object: DRAWABLE_OBJECT) is
			-- Insert `an_object' into drawable objects.
		require
			an_object_exists: an_object /= Void
		do
			if not Drawable_objects.has (an_object) then
				Drawable_objects.extend (an_object)
			end
		end

	remove_command (an_object: DRAWABLE_OBJECT) is
			-- Remove `an_object' from drawable objects.
		require
			an_object_exists: an_object /= Void
		do
			drawable_objects.start
			if Drawable_objects.has (an_object) then
				Drawable_objects.prune (an_object)
			end
		end

	execute_command (a_list: LIST [DRAWABLE_OBJECT]; 
			a_command: PROCEDURE [ANY, TUPLE [DRAWABLE_OBJECT]]) is
			-- Execute `a_command' for all elements in `a_list'.
		require
			a_list_exists: a_list /= Void
			a_list_not_empty: not a_list.is_empty
			a_command_exists: a_command /= Void
		do
			from
				a_list.start
			until
				a_list.after
			loop
				a_command.call ([a_list.item])
				a_list.forth
			end
		end

feature -- Conversion

	real_coordinate (a_coordinate: COORDINATE): REAL_COORDINATE is
			-- REAL coordinate representation of `a_coordinate'
		require
			a_coordinate_exists: a_coordinate /= Void
		local
			x, y: REAL
		do
			x := a_coordinate.x
			y := a_coordinate.y
			create Result.make (x, y)
		ensure
			Result_exists: Result /= Void
		end

end -- class SHARED_DRAWABLE_OBJECTS

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
