indexing
	description: 
		"[
			XML processors for <place_displayer> elements.
		 ]"
		
	author: "Marcel Kessler & Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.3 $"

class PLACE_DISPLAYER_NODE_PROCESSOR inherit
	
	NODE_PROCESSOR
		redefine 
			process_subnodes 
		end
		
	DISPLAYER_ACCESSOR
		
create
	make

feature -- Access

	Name: STRING is "place_displayer"
			-- Name of element to process

	Mandatory_attributes: ARRAY [STRING] is
			-- Table of mandatory attributes
		do
			Result := <<  >>
			Result.compare_objects
		end

feature -- Basic operations

	process is
			-- Process node.
		local
			pd: PLACE_DISPLAYER
			p: PLACE
		do
			p ?= target
			if p /= Void and not p.has_displayer then
				create pd.make (p)
				p.set_displayer (pd)
			else
				set_place_displayer (p)
				pd := place_displayer
			end
			if has_attribute ("file") and pd /= Void then
				pd.set_pixmap_file_name (attribute ("file"))
			end
			if has_subnodes then
				process_subnodes
			end			
			if not has_error and point /= void then
				p.set_position (point)
			end
		end

	process_subnodes is
			-- Process subnodes.
		local
			n: XM_ELEMENT
			p: NODE_PROCESSOR
			position: COORDINATE
		do
			from
				subnodes.start
			until
				has_error or subnodes.after
			loop
				position := Void
				n := subnodes.item
				if has_processor (n.name) then
					p := processor (n.name)
				else
					set_error (Unknown_subnode, << p.name >>)
				end
				if not has_error then
					p.set_source (n)
					p.set_parent (Current)
					if has_target then
						p.set_target (target)
					end
					if not p.has_error then
						p.process
						-- A point has been generated
						position ?= data
						if position /= Void then
							point := position
						end
					else
						set_error (p.error_code, << >>)
					end
				end
				subnodes.forth
			end
		end

feature {NONE} -- Implementation
		
	point: COORDINATE
			-- The position of this place
			

end -- class PLACE_DISPLAYER_NODE_PROCESSOR

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
