indexing
	description: 
		"[
			XML processors for <link_displayer> elements.
		 ]"
		
	author: "Marcel Kessler & Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/08/17 08:11:14 $"
	revision: "$Revision: 1.1 $"

class
	LINE_DISPLAYER_NODE_PROCESSOR

inherit
	
	NODE_PROCESSOR
		redefine process_subnodes end
create
	make

feature -- Access

	Name: STRING is "line_displayer"
			-- Name of element to process
		
	Mandatory_attributes: ARRAY [STRING] is
			-- Table of mandatory attributes
		do
			Result := << "thickness" >>
			Result.compare_objects
		end

feature -- Basic operations

	process is
			-- Process node.
		local
			ld: LINE_DISPLAYER
			l: LINE
		do
			l ?= target
			if l /= Void then
				create ld.make (l)
			end
			if has_attribute ("thickness") and is_attribute_integer ("thickness") then
				ld.set_line_thickness (attribute_integer ("thickness"))
			end
			if has_attribute ("dashed") and attribute ("dashed").is_equal ("dashed") then
				ld.set_dashed (True)
			else 
				ld.set_dashed (False)
			end
			if has_subnodes then
				process_subnodes
			end
			if not has_error then
				if standard_color /= Void then
					ld.set_standard_color (standard_color)
				end
				if highlight_color /= Void then
					ld.set_highlight_color (highlight_color)
				end
				l.set_displayer (ld)
			end
		end

	process_subnodes is
			-- Process subnodes.
		local
			n: XM_ELEMENT
			p: NODE_PROCESSOR
			color: EV_COLOR
		do
			from
				subnodes.start
			until
				has_error or subnodes.after
			loop
				color := Void
				n := subnodes.item
				if has_processor (n.name) then
					p := processor (n.name)
				else
					set_error (Unknown_subnode, << p.name >>)
				end
				if not has_error then
					p.set_source (n)
					p.set_parent (Current)
					if has_target then
						p.set_target (target)
					end
					if not p.has_error then
						p.process
						color ?= data
						if color /= Void then
							if p.has_attribute ("type") and then p.attribute ("type").is_equal ("highlight") then
								highlight_color := color
							else
								standard_color := color
							end
						end
					else
						set_error (p.error_code, << >>)
					end
				end
				subnodes.forth
			end
		end

feature {NONE} -- Implementation
		
	standard_color: EV_COLOR
			-- Standard color for the generated link
	
	highlight_color: EV_COLOR
			-- Highlight color for the generated link

end 

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------

