indexing

	description: "[
					Objects that can be drawn on EV_CANVAS and
					that will scale when zooming
					]"
	status:	"See notice at end of class"
	author: "Till G. Bay"
	date: "$Date: 2004/08/25 12:03:42 $"
	revision: "$Revision: 1.2 $"

deferred class DRAWABLE_OBJECT

feature -- Commands
		
	set_color (a_color: like color) is
			-- Set the color of the object to `a_color'
		require
			a_color_not_void: a_color /= Void
		do
			color := a_color
		ensure
			color_set: color = a_color
		end
		
feature -- Display

	bounding_box: REAL_RECTANGLE is
			-- The bounding box of `Current'
		deferred
		ensure
			bounding_box_not_void: Result /= Void
		end
		
	draw (a_target: CANVAS) is
			-- Draw `Current' onto `a_target'
		require
			a_target_not_void: a_target /= Void
		do
			check
				color_not_void: color /= Void
			end
			canvas := a_target
			canvas.set_foreground_color (color)
			draw_object
		ensure
			canvas_set: canvas = a_target
			-- Should work -> Vision2 bug?
			-- canvas_foreground_color_set: canvas.foreground_color = color
		end
		
	draw_object is
			-- Draw the object.
		deferred
		end

	real_to_integer_coordinate (a_real_coordinate: REAL_COORDINATE): EV_COORDINATE	is
			-- Convert `a_real_coordinate' to an integer coordinate.
		require
			a_real_coordinate_not_void: a_real_coordinate /= Void
			canvas_visible_area_width_not_zero: canvas.visible_area.width /= 0.0
			canvas_visible_area_height_not_zero: canvas.visible_area.height /= 0.0
		local
			x_int : INTEGER
			y_int : INTEGER
		do
			x_int := (((a_real_coordinate.x-canvas.visible_area.left_bound) * canvas.width) / 
					   canvas.visible_area.width).rounded
			y_int := canvas.height +
					(((canvas.visible_area.lower_bound-a_real_coordinate.y) * canvas.height) / 
					   canvas.visible_area.height).rounded
			create Result.set (x_int,y_int)
		ensure
			result_not_void: Result /= Void
		end

	integer_to_real_coordinate (an_integer_coordinate: EV_COORDINATE): REAL_COORDINATE is
			-- Convert `an_integer_coordinate' to a real coordinate.
		require
			an_integer_coordinate_not_void: an_integer_coordinate /= Void
			canvas_width_not_zero: canvas.width /= 0
			canvas_height_not_zero: canvas.height /= 0
		local
			x_real : REAL
			y_real : REAL
		do

			x_real:= ((an_integer_coordinate.x * canvas.visible_area.width) / canvas.width) + canvas.visible_area.left_bound
			y_real:= ((an_integer_coordinate.y * canvas.visible_area.height) / canvas.height) + canvas.visible_area.lower_bound
			create Result.make (x_real,y_real)
		ensure
			result_not_void: Result /= Void			
		end

feature -- Implementation

	canvas : CANVAS
			-- Reference to the canvas
		
	color: EV_COLOR
			-- The color of the drawable object
		
invariant
	
	color_not_void: color /= Void

end


--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Till G. Bay <tillbay@student.ethz.ch>
--|
--|--------------------------------------------------------
