indexing

	description: "[ 
			Sub pixmaps for use with EV_CANVAS not scaling.
			Therefore position is given in the center.
			]"
	status:	"See notice at end of class"
	author: "Till G. Bay"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.4 $"

class DRAWABLE_ICON inherit
	
	DRAWABLE_OBJECT

create

	make

feature -- Creation

	make (a_sub_pixmap: EV_PIXMAP; a_position: REAL_COORDINATE ) is
			-- Create a `a_sub_pixmap' at `a_position'.
		require
			a_sub_pixmap_not_void: a_sub_pixmap /= Void
			a_position_not_void: a_position /= Void
		do
			position:= a_position
			pixmap:= a_sub_pixmap
			set_color (create {EV_COLOR}.make_with_rgb (0.0, 0.0, 0.0))
			create area.make (0, 0, pixmap.width, pixmap.height)
		ensure
			position_set: position = a_position
			pixmap_set: pixmap = a_sub_pixmap
		end
	
feature -- Element change

	set_position (a_coordinate: REAL_COORDINATE) is
			-- 
		do
			create position.make (a_coordinate.x, a_coordinate.y)
		end
		
feature -- Access

	bounding_box : REAL_RECTANGLE is
			-- The bounding box of the icon
		local
			p1: REAL_COORDINATE
			p2: REAL_COORDINATE
			w: DOUBLE
			h: DOUBLE
		do
--			h := (pixmap.height * Map.width_ratio) / 2
--			w := (pixmap.width * Map.height_ratio) / 2
--			create p1.make (position.x - w, position.y - h)
--			create p2.make (position.x + w, position.y + h)
--			create Result.make (p1, p2)
			create Result.make (position, create {REAL_COORDINATE}.make (position.x + pixmap.width, position.y + pixmap.height))
		end
		
feature {CANVAS} -- Display

	draw_object is
			-- Draw the icon.
		local
			scaled_position : EV_COORDINATE
			coord: REAL_COORDINATE
		do
			create coord.make (position.x+pixmap.width/2, position.y-pixmap.height/2)
			scaled_position := real_to_integer_coordinate (coord)
			canvas.draw_sub_pixmap (scaled_position.x-(pixmap.width/2).floor, scaled_position.y-(pixmap.height/2).floor, pixmap, area)
		end
	
feature {NONE} -- Implementation

	position: REAL_COORDINATE
			-- Position of the icon
	
	pixmap: EV_PIXMAP
			-- The icon
	
	area: EV_RECTANGLE
			-- The area of the icon 
		
invariant

	position_not_void: position /= Void
	pixmap_not_void: pixmap /= Void
	area_not_void: area /= Void

end


--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Till G. Bay <tillbay@student.ethz.ch>
--|
--|--------------------------------------------------------
