indexing
	description: 
		"[
			Accessor that makes accessing of displayers easier
		 ]"
		 
	status:	"See notice at end of class"
	author: "Marcel Kessler, Rolf Bruderer & Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.1 $"

class DISPLAYER_ACCESSOR

feature -- Displayer access

	city_displayer: CITY_DISPLAYER
			-- Actual city displayer set by `set_city_displayer'
	
	place_displayer: PLACE_DISPLAYER
			-- Actual place displayer set by `set_place_displayer'
	
	link_displayer: LINK_DISPLAYER
			-- Actual link displayer set by `set_link_displayer'
			
	line_displayer: LINE_DISPLAYER
			-- Actual line displayer set by `set_line_displayer'

feature -- Element change

	set_city_displayer (a_city: CITY) is
			-- Set `city_displayer' to displayer of `a_city'.
		require
			a_city_exists: a_city /= Void
			a_city_has_displayer: a_city.has_displayer
		do
			city_displayer ?= a_city.displayer
			check
				city_displayer /= Void
			end
		ensure
			city_displayer_set: city_displayer /= Void and city_displayer = a_city.displayer
		end
	
	set_place_displayer (a_place: PLACE) is
			-- Set `place_displayer' to displayer of `a_place'.
		require
			a_place_exists: a_place /= Void
			a_place_has_displayer: a_place.has_displayer			
		do
			place_displayer ?= a_place.displayer
			check
				place_displayer /= Void
			end
		ensure
			place_displayer_set: place_displayer /= Void and place_displayer = a_place.displayer
		end
	
	set_link_displayer (a_link: LINK) is
			-- Set `link_displayer' to displayer of `a_link'.
		require
			a_link_exists: a_link /= Void
			a_link_has_displayer: a_link.has_displayer			
		do
			link_displayer ?= a_link.displayer
			check
				link_displayer /= Void
			end
		ensure
			link_displayer_set: link_displayer /= Void and link_displayer = a_link.displayer
		end

	set_line_displayer (a_line: LINE) is
			-- Set `line_displayer' to displayer of `a_line'.
		require
			a_line_exists: a_line /= Void
			a_line_has_displayer: a_line.has_displayer			
		do
			line_displayer ?= a_line.displayer
			check
				line_displayer /= Void
			end
		ensure
			line_displayer_set: line_displayer /= Void and line_displayer = a_line.displayer
		end
		
end 

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Marcel Kessler <kesslema@student.ethz.ch>
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--| 	Rolf Bruderer <bruderer@computerscience.ch>
--|
--|--------------------------------------------------------
