indexing
	description: 
		"[
			Nodes in a graph.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/07/21 11:02:24 $"
	revision: "$Revision: 1.1 $"

class NODE [G -> HASHABLE, H] 

create
	make
	
feature {GRAPH} -- Initialization

	make (a_data: G) is
			-- Set `data' to `a_data'.
		require
			a_data_exists: a_data /= Void
			no_data_yet: data = Void
		do
			create edges.make
			data := a_data
		ensure
			data_set: data = a_data
			edges_exist: edges /= Void
			no_edges: edges.count = 0
		end
		
feature -- Access

	data: G
			-- Data that is stored in the node
			-- At the same time used as identifier
	
feature {GRAPH} -- Implementation
	
	add_edge (an_edge: EDGE [G, H]) is
			-- Add `an_edge' to the edges that start from this node.
		require
			an_edge_exists: an_edge /= Void
			has_right_source: an_edge.source_key = data
		do
			edges.put_last (an_edge)
		ensure
			one_more: edges.count = old edges.count + 1
		end
		
feature {GRAPH, GRAPH_TRAVERSER} -- Implementation

	edges: DS_LINKED_LIST [EDGE [G, H]]
			-- List of all outgoing edges of this node
		
invariant

	edges_exists: edges /= Void
	data_exists: data /= Void
	
end -- class NODE

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
