indexing
	description: 
		"[
			Places in a city that belong to the public transportation system.
			They should have at least one outgoing or incoming link that is of type Rail, Bus, or Metro.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.4 $"

class STATION inherit 

	PLACE
		redefine 
			make, 
			has_description, 
			description 
		end
	
create
	make
	
feature -- Initialization

	make (a_name: STRING) is
			-- Set `name' to `a_name'.
		do
			Precursor (a_name)
			is_station := True
		end
	
feature -- Access

	public_transportation_lines: LINKED_LIST [LINE] is
				-- Lines that lead through this station
				-- (Recomputed on each call)
		local
			l: LINKED_LIST [LINK]
		do
			create Result.make
			from
				l := public_transportation_links
				l.start
			until
				l.off
			loop
				if not Result.has (l.item.line) then
					Result.extend (l.item.line)
				end
				l.forth
			end
		end
		
	public_transportation_links: LINKED_LIST [LINK] is
			-- Outgoing links that are of a public transportation type
			-- (Recomputed on each call)
		do
			Result := outgoing_links
			from
				Result.start
			until
				Result.off
			loop
				if not Result.item.is_public_transport (Result.item.type) then
					Result.remove				
				else
					Result.forth
				end
			end
		end
		
feature -- Status report

	has_description: BOOLEAN is True
			-- Does the station have a description?
	
feature -- Element change

	description: STRING is
			-- Description of the station
		local
			ptl: LINKED_LIST [LINE]
		do
			if internal_description /= Void then
				Result := internal_description
			else
				-- Generate description
				Result := name + " offers the following lines: %N"
				from
					ptl := public_transportation_lines
					ptl.start
				until
					ptl.off
				loop
					Result := Result + ptl.item.name + ": " + ptl.item.sw_to_ne_line.first_place.name + " --> " + ptl.item.sw_to_ne_line.last_place.name + " ||| " +
						ptl.item.ne_to_sw_line.first_place.name + " --> " + ptl.item.ne_to_sw_line.last_place.name + "%N"
					ptl.forth
				end
			end
		ensure then
			Result_exists: Result /= Void
		end
		
end -- class STATION

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
