indexing
	description: 
		"[
			Routes in a city.
		 ]"
		 
	author: "Michela Pedroni"
	date: "$Date: 2004/07/21 11:02:18 $"
	revision: "$Revision: 1.1 $"

class
	ROUTE

create
	make

feature -- Initialization

	make (a_places_to_visit_list: LINKED_LIST [PLACE]) is
			-- Initialize so that `places_to_visit' holds all elements of list `p'.
		require
			a_places_to_visit_list_exists: a_places_to_visit_list /= Void
		do
			create links.make
			create places_to_visit.make
			create places_on_route.make
			from
				a_places_to_visit_list.start
			until
				a_places_to_visit_list.off
			loop
				places_to_visit.extend (a_places_to_visit_list.item)
				a_places_to_visit_list.forth
			end
		end
		
feature -- Access

	places_to_visit: LINKED_LIST [PLACE]
			-- Places that are to be visited by this route
			
	places_on_route: LINKED_LIST [PLACE]
			-- All the places that the route leads through (in the right order --> a place may occur more than once)

	links: LINKED_LIST [LINK]
			-- Links that are used to visit the places (order is relevant)
			
end -- class ROUTE

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
