indexing
	description: 
		"[
			Places in a city (e.g. stations, stops, landmarks, parks, shopping center).
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.4 $"

class PLACE inherit
	
	ANY	
		redefine 
			out 
		end
		
	HASHABLE
		undefine 
			out 
		end
		
	CITY_ELEMENT
		undefine 
			out 
		end
	
create 
	make
	
feature -- Initialization

	make (a_name: STRING) is
			-- Set `name' to `a_name'.
		require
			a_name_exists: a_name /= Void
		do
			if name = Void then
				name := a_name			
			end
			create position
		end
		
feature -- Access

	name: STRING
			-- Name of the place (at the same time identifier)
	
	position: COORDINATE
			-- Position on the map
	
	hash_code: INTEGER is
			-- Hash code value
		do
			Result := name.hash_code
		end

	outgoing_links: LINKED_LIST [LINK] is
			-- Links that start at this place
			-- Recomputed on each call
		do
			Result := city.transport_network.outgoing_links (Current)
		end

feature -- Status report

	is_station: BOOLEAN
			-- Is this place a station?
	
	is_museum: BOOLEAN
			-- Is this place a museum?
	
feature -- Element change

	set_position (a_coordinate: COORDINATE) is
			-- Set `position' to `a_coordinate'.
		require
			a_coordinate_exists: a_coordinate /= Void
		do
			position := a_coordinate
		ensure
			position_set: position = a_coordinate
		end

feature -- Output

	out: STRING is
			-- New string containing printable representation of current object
		do
			Result := "Place: " + name + "%N"
		end

invariant
	
	name_not_void: name /= Void

end -- class PLACE

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
