indexing
	description: 
		"[
			XML processors for <link> nodes.
		 ]"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach, Michela Pedroni"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.4 $"

class LINK_NODE_PROCESSOR inherit

	NODE_PROCESSOR
		redefine 
			process_subnodes
		end

create
	make

feature -- Access

	Name: STRING is "link"
			-- Name of element to process
		
	Mandatory_attributes: ARRAY [STRING] is
			-- Table of mandatory attributes
		do
			Result := << "from", "to" >>
			Result.compare_objects
		end

feature -- Basic operations

	process is
			-- Process node.
		local
			line: LINE
		do
			line ?= parent.target
			if not has_attribute ("from") then
				set_error (Mandatory_attribute_missing, <<"from">>)
			elseif not has_attribute ("to") then
				set_error (Mandatory_attribute_missing, <<"to">>)
			elseif not city.has_place (attribute ("from")) then
				set_error (Unknown_source, <<attribute ("from")>>)
			elseif not city.has_place (attribute ("to")) then
				set_error (Unknown_destination, << attribute ("to")>> )
			elseif line = Void then
				set_error (Missing_line, << >> )
			elseif not city.lines.has (line.name) then
				set_error (Unknown_line, << line.name >>)
			else
				if has_attribute ("direction") and then attribute ("direction").is_equal ("undirected") then
					if not city_factory.line.is_valid_link_for_insertion (city.places.item (attribute ("from")), city.places.item (attribute ("to")), False) then
						set_error (Invalid_link, << city_factory.line.name, attribute ("from"), attribute ("to") >>)
					else
						city_factory.build_link (( attribute ("from")), ( attribute ("to")), False, city, line)
					end
				else
					if not city_factory.line.is_valid_link_for_insertion (city.places.item (attribute ("from")), city.places.item (attribute ("to")), True) then
						set_error (Invalid_link, << city_factory.line.name, attribute ("from"), attribute ("to") >>)
					else						
						city_factory.build_link (( attribute ("from")), ( attribute ("to")), True, city, line)
					end
				end	
				set_target (city_factory.link)
			end
			if not has_error and has_subnodes then
				process_subnodes
			end
			if not has_error and polypoints.count >= 2 then
				city_factory.link.set_polypoints (polypoints)		
				
				-- adjust the positions of the start and end place of this link
				if city_factory.link.from_place.position = Void then
					city_factory.link.from_place.set_position 
						(create {COORDINATE}.make (polypoints.first.x, polypoints.first.y))
				else
					city_factory.link.from_place.set_position 
						(create {COORDINATE}.make (	(city_factory.link.from_place.position.x + polypoints.first.x)// 2,
													(city_factory.link.from_place.position.y + polypoints.first.y)// 2))
				end
				if city_factory.link.to_place.position = Void then
					city_factory.link.to_place.set_position 
						(create {COORDINATE}.make (polypoints.last.x, polypoints.last.y))
				else
					city_factory.link.from_place.set_position 
						(create {COORDINATE}.make (	(city_factory.link.to_place.position.x + polypoints.last.x)// 2,
													(city_factory.link.to_place.position.y + polypoints.last.y)// 2))
				end
			end
		end

	process_subnodes is
			-- Process subnodes.
		local
			n: XM_ELEMENT
			p: NODE_PROCESSOR
			position: COORDINATE
		do
			create polypoints.make (0)
			from
				subnodes.start
			until
				has_error or subnodes.after
			loop
				position := Void
				n := subnodes.item
				if has_processor (n.name) then
					p := processor (n.name)
				else
					set_error (Unknown_subnode, << p.name >>)
				end
				if not has_error then
					p.set_source (n)
					p.set_parent (Current)
					if has_target then
						p.set_target (target)
					end
					if not p.has_error then
						p.process
						-- Has a point been generated?
						position ?= data
						if position /= Void then
							polypoints.extend (position)
						end
					else
						set_error (p.error_code, << >>)
					end
				end
				subnodes.forth
			end
		end

	polypoints: ARRAYED_LIST [COORDINATE]
			-- Polypoints of this link
		
end

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Patrick Schoenbach <pschoenb@gmx.de>
--|		Michela Pedroni <pedronim@inf.ethz.ch>
--|
--|--------------------------------------------------------
