indexing
	description: 
		"[
			XML processors for <line> nodes.
		 ]"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach, Michela Pedroni"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.3 $"

class LINE_NODE_PROCESSOR inherit

	NODE_PROCESSOR

create
	make

feature -- Access

	Name: STRING is "line"
			-- Name of element to process
		
	Mandatory_attributes: ARRAY [STRING] is
			-- Table of mandatory attributes
		do
			Result := << "name", "type" >>
			Result.compare_objects
		end

feature -- Basic operations

	process is
			-- Process node.
		do
			if not has_attribute ("name") then
				set_error (Mandatory_attribute_missing, << "name" >>)
			elseif not has_attribute ("type") then
				set_error (Mandatory_attribute_missing, << "type" >>)
			else
				city_factory.build_line (attribute ("name"), attribute ("type"), city)
				set_target (city_factory.line)
			end
			if not has_error and has_subnodes then
				process_subnodes
			end			
		end
		
end

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Patrick Schoenbach <pschoenb@gmx.de>
--|		Michela Pedroni <pedronim@inf.ethz.ch>
--|
--|--------------------------------------------------------
