indexing
	description:
		"[
			XML processors for <description> nodes.
		 ]"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach, Michela Pedroni"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class DESCRIPTION_NODE_PROCESSOR inherit

	NODE_PROCESSOR

create
	make

feature -- Access

	Name: STRING is
			-- Name of node to process
		once
			Result := "description"
		end
		
	Mandatory_attributes: ARRAY [STRING] is
			-- Table of mandatory attributes
		do
			Result := << >>
			Result.compare_objects
		end

feature -- Basic operations

	process is
			-- Process element.
		do
				check
					has_target: has_target
						-- Because it has been passed down from the parent.
				end
			if has_text then
				target.set_description (text)
			end

			if has_subnodes then
				process_subnodes
			end
		end

end -- class DESCRIPTION_NODE_PROCESSOR

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Patrick Schoenbach <pschoenb@gmx.de>
--|		Michela Pedroni <pedronim@inf.ethz.ch>
--|
--|--------------------------------------------------------
