indexing
	description:
		"[
			XML parser for the map data.
		 ]"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach, Michela Pedroni"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class CITY_PARSER inherit

	XML_INPUT_FILE_PARSER
	
	NODE_PROCESSOR_REGISTRY
	
create
	make_with_factory

feature -- Initialization

	make_with_factory (a_city_factory: CITY_FACTORY) is
			-- Create parser with `a_city_factory'.
		require
			a_city_factory_exists: a_city_factory /= Void
		do
			make
			from
				Processor_registry.start
			until
				Processor_registry.off
			loop
				Processor_registry.item_for_iteration.set_city_factory (a_city_factory)
				Processor_registry.forth
			end
		end
		
feature -- Status report

	can_process: BOOLEAN is
			-- Can document tree be processed?
		do
			Result := is_parsed and then has_processor (root_element.name)
		end
	
feature -- Basic operations
	
	process is
			-- Process document tree.
		local
			p: NODE_PROCESSOR
		do
			p := processor (root_element.name)
			p.set_source (root_element)
			if p.has_error then
				set_error (p.error_code, p.slots)
				is_parsed := False
			end
			if not has_error then
				p.process
				if p.has_error then
					set_error (p.error_code, p.slots)
					is_parsed := False
				end
			end
			set_city_factory (p.city_factory)
		end
		
invariant

	can_process_definition: can_process = (is_parsed and 
			has_processor (root_element.name))

end

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Patrick Schoenbach <pschoenb@gmx.de>
--|		Michela Pedroni <pedronim@inf.ethz.ch>
--|
--|--------------------------------------------------------
