indexing
	description: 
		"[
			Abstract class for objects that are displayable.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

deferred class DISPLAYABLE

feature -- Access

	displayer: DISPLAYER
			-- Displayer object for this displayable
		
feature -- Status setting

	set_displayer (a_displayer: DISPLAYER) is
			-- Set the `displayer' to `a_displayer'.
		require
			disp_has_element: a_displayer.element = Current
		do
			displayer := a_displayer
		ensure
			element_set: displayer = a_displayer
		end

feature -- Status report

	has_displayer: BOOLEAN is
			-- Does this object have a displayer?
		do
			Result := displayer /= Void
		end

end -- class DISPLAYABLE

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
