indexing
	description: 
		"[
			Coordinates where x and y are integers
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class COORDINATE inherit
	
	DOUBLE_MATH
		redefine 
			out 
		end

create 
	make, default_create
	
feature -- Initialization

	x: INTEGER
			-- x-value of coordinate
	
	y: INTEGER
			-- y-value of coordinate
	
feature -- Element change

	make, set (a_x, a_y: INTEGER) is
			-- Assign `a_x' to `x' and `a_y' to `y'.
		do
			x := a_x
			y := a_y
		ensure
			x_assigned: x = a_x
			y_assigned: y = a_y
		end

	set_x (a_x: INTEGER) is
			-- Assign `a_x' to `x'.
		do
			x := a_x
		ensure
			x_assigned: x = a_x
		end

	set_y (a_y: INTEGER) is
			-- Assign `a_y' to `y'.
		do
			y := a_y
		ensure
			y_assigned: y = a_y
		end

feature -- Operations

	infix "-" (a_coordinate: like Current): like Current is
			-- Subtraction of `a_coordinate' from `current'
		do
			create Result.make (x - a_coordinate.x, y - a_coordinate.y)
		end

	infix "+" (a_coordinate: like Current): like Current is
			-- Addition of `a_coordinate' and `current'
		do
			create Result.make (x + a_coordinate.x, y + a_coordinate.y)
		end

	infix "*" (a_coordinate: like Current): INTEGER is
			-- Scalar product of `Current' and `a_scalar'
		do
			Result := x * a_coordinate.x + y * a_coordinate.y
		end
		
	distance (a_coordinate: like Current): DOUBLE is
			-- Distance between `Current' and `a_coordinate'
		local
			c: COORDINATE
		do
			c := a_coordinate - Current
			Result := sqrt (c.x^2 + c.y^2)
		end
		
feature -- Output

	out: STRING is
			-- Textual representation.
		do
			Result := "(X: " + x.out + ", Y: " + y.out + ")"
		end

end -- class COORDINATE

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
