indexing
	description: 
		"[
			Elements belonging to a city.
		 ]"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach, Michela Pedroni"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.3 $"

deferred class CITY_ELEMENT inherit 

	DISPLAYABLE

feature -- Attributes

	description: STRING is
			-- Description of the element
		require
			has_description: has_description
		do
			Result := internal_description
		end
		
	city: CITY
			-- City to which the city element belongs	
	
feature -- Status report

	has_description: BOOLEAN is
			-- Does the element have a description?
		do
			Result := internal_description /= Void
		end		
		
feature -- Status setting

	set_description (a_description: STRING) is
			-- Set description to `a_description'.
		do
			internal_description := a_description
		end

	set_city (a_city: CITY) is
			-- Set `city' to `a_city'.
		require
			a_city_exists: a_city /= Void
		do
			city := a_city
		ensure
			city_set: city = a_city
		end

feature {NONE, CITY_FACTORY} -- Implementation

	internal_description: STRING
			-- Internal description of the city element
		
end

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Patrick Schoenbach <pschoenb@gmx.de>
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
