indexing
	description: 
		"[
			Constants used by the main window.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.4 $"

class MAIN_WINDOW_CONSTANTS	inherit
	
	KL_SHARED_FILE_SYSTEM
	
feature -- Constants (Numbers)

	First_mode_value,
	Selection_mode,
	Move_mode,
	Information_mode,
	Last_mode_value: INTEGER is unique
			-- Values for the modes of the user interface

	Button_padding: INTEGER is 8
			-- Padding of the button panel

	Default_zoom: REAL is 1.0
			-- Default zoom factor
		
	Zoom_factor_seamless: REAL is 0.01
			-- Seamless zoom factor
		
	Zoom_factor_stepwise: REAL is 0.05
			-- Stepwise zoom factor

	Window_title: STRING is "TOUCH"
			-- Title of the window

	Window_width: INTEGER is 1050
			-- Initial width for this window

	Window_height: INTEGER is 600
			-- Initial height for this window
			
	Pan_distance: INTEGER is 30
			-- Distance to move the Map
			
	Scaling_reference: REAL is 634.0
			-- The reference value for line width scaling

feature -- Constants (Names of window items, tooltips)

	Button_ok_text: STRING is "OK"
			-- String for "OK" buttons.

	File_menu_text: STRING is "&File"
			-- String for menu "File"

	File_open_item_text: STRING is "&Open Map...%TCtrl+O"
			-- String for menu "File/Open"

	File_exit_item_text: STRING is "E&xit"
			-- String for menu "File/Exit"

	Help_menu_text: STRING is "&Help"
			-- String for menu "Help"

	Help_contents_item_text: STRING is "&Contents and Index"
			-- String for menu "Help/Contents and Index"

	Help_about_item_text: STRING is "&About..."
			-- String for menu "Help/About"

	Selection_tooltip: STRING is "Tool to select stations"
			-- Tooltip for selection button

	Zoom_in_tooltip: STRING is "Zoom in"
			-- Tooltip for zoom in button

	Zoom_out_tooltip: STRING is "Zoom out"
			-- Tooltip for zoom out button

	Info_tooltip: STRING is "Tool to obtain information on map elements"
			-- Tooltip for information button

	Info_cursor_shape: STRING is "info_cursor"
			-- Image of information cursor shape
			
	Move_button_image: STRING is "move.png"
			-- Image of move button

	Move_cursor_shape: STRING is "move_cursor"
			-- Image of move cursor shape
			
	Move_tooltip: STRING is "Tool to move the map"
			-- Tooltip for selection button

	Cursor_hotspot_x: INTEGER is 16
			-- X coordinate of cursor hotspot

	Cursor_hotspot_y: INTEGER is 16
			-- Y coordinate of cursor hotspot
			
	Name_display_tooltip: STRING is "Display names on/off"
	
	Route_calculation_tooltip: STRING is "Calculate route between selected places"
	
	About_title: STRING is "About TOUCH"
			-- Default title for the dialog window.

	About_message: STRING is
		"TOUCH%N%
		%Version 2.0%N%
		%%N%
		%Copyright (C) 2004 ETH Zurich"

	About_icon: STRING is "landmark_info"
			-- Name of application icon

feature -- Constants (Images)

	Application_icon: STRING is "application_icon_16x16"
			-- Name of application icon

	Button_images: ARRAY [STRING] is
			-- Names of images for tool bar
		once
			Result := << "zoom_in", "zoom_out", "selection", "move", 
				"landmark_info", "name_display", "shortest_path" >>
		ensure
			Result_exists: Result /= Void
			Result_not_empty: not Result.is_empty
		end
		
	Route_calculation_button_image: STRING is
			-- Name of button image for route calculation
		do
			Result := "shortest_path"
		end

	Image_directory: STRING is
			-- Name of the directory where the icon images are located
		once
			Result := File_system.pathname_from_file_system (File_system.current_working_directory + "\images", Windows_file_system)
		end
	
	Inactivity_suffix: STRING is "_inactive"
			-- Suffix for inactive button images
			
	Image_extension: STRING is 
		once
			if File_system = Unix_file_system then
				Result := ".png"
			else
				Result := ".ico"
			end
		end

end -- class MAIN_WINDOW_CONSTANTS

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
