indexing
	description: 
		"[
			Button panel for example and exercise buttons.
		 ]"		
	
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/07/21 11:02:18 $"
	revision: "$Revision: 1.1 $"

class BUTTON_PANEL inherit
	
	EV_VERTICAL_BOX

feature -- Initialization

	set_up is
			-- Setup the button panel.
		local
			label: EV_LABEL
			sep: EV_HORIZONTAL_SEPARATOR
			vb: EV_VERTICAL_BOX
		do
			set_border_width (5)
			create sep
			create label.make_with_text ("Examples")
			create example_table
			create vb
			example_table.set_border_width (5)
			example_table.set_column_spacing (2)
			example_table.set_row_spacing (2)
			vb.extend (label)
			vb.extend (example_table)
			vb.disable_item_expand (label)
			vb.disable_item_expand (example_table)
			extend (vb)
			extend (sep)
			create label.make_with_text ("Exercises")
			create exercise_table
			create vb
			exercise_table.set_border_width (5)
			exercise_table.set_column_spacing (2)
			exercise_table.set_row_spacing (2)
			vb.extend (label)
			vb.extend (exercise_table)
			vb.disable_item_expand (label)
			vb.disable_item_expand (exercise_table)
			extend (vb)
		end

feature -- Basic operations

	setup_examples_from_container (a_list: HASH_TABLE [EXECUTABLE, STRING]) is
			-- Take `a_list' and add them to the button panel.
		require
			a_list_exists: a_list /= Void
		do
			from
				a_list.start
			until
				a_list.off
			loop
				add_example_button (a_list.key_for_iteration, a_list.item_for_iteration)
				a_list.forth
			end
		ensure
			count_is_correct: example_table.count = old example_table.count + a_list.count
		end

	setup_exercises_from_container (a_list: HASH_TABLE [EXECUTABLE, STRING]) is
			-- Take `a_list' and add them to the button panel.
		require
			a_list_exists: a_list /= Void
		do
			from
				a_list.start
			until
				a_list.off
			loop
				add_exercise_button (a_list.key_for_iteration, a_list.item_for_iteration)
				a_list.forth
			end
		ensure
			count_is_correct: exercise_table.count = old exercise_table.count + a_list.count
		end
		
	add_example_button (a_name: STRING; an_executable: EXECUTABLE) is
			-- Add a button to the examples with name `a_name' and functionality `an_executable'.
		require
			a_name_exists: a_name /= Void
			a_name_not_empty: not a_name.is_empty
			an_executable_exists: an_executable /= Void
		local
			b: EV_BUTTON
		do
			create b.make_with_text_and_action (a_name, agent an_executable.run)
			b.set_minimum_size (80, 30)
			example_table.resize (1, example_table.count + 1)
			example_table.add (b, 1, example_table.count + 1, 1, 1)
			example_table.show
		ensure
			one_more: example_table.count = old example_table.count + 1
		end
		
	add_exercise_button (a_name: STRING; an_executable: EXECUTABLE) is
			-- Add a button to the exercises with name `a_name' and functionality `an_executable'.
		require
			a_name_exists: a_name /= Void
			a_name_not_empty: not a_name.is_empty
			an_executable_exists: an_executable /= Void
		local
			b: EV_BUTTON
		do
			create b.make_with_text_and_action (a_name, agent an_executable.run)
			b.set_minimum_size (80, 30)
			exercise_table.resize (1, exercise_table.count + 1)
			exercise_table.add (b, 1, exercise_table.count + 1, 1, 1)
			exercise_table.show
		ensure
			one_more: exercise_table.count = old exercise_table.count + 1
		end

feature {NONE} -- Implementation

	example_table: EV_TABLE
			-- Table with all the example buttons
	
	exercise_table: EV_TABLE
			-- Table with all the exercise buttons
	
end -- class BUTTON_PANEL

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
