indexing
	description: 
		"[
			Stops that may build up lines
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class STOP inherit
	
create	
	set_station

feature -- Access

	station: PLACE
			-- Place which this stop represents

	next: STOP
			-- Next stop on the same line

feature -- Status report

	is_linked: BOOLEAN is
			-- Is current stop linked?
		do
			Result := (next /= Void)
		end
		
feature -- Element change

	set_station (s: PLACE) is
			-- Set current stop to `s'.
		require
			station_exists: s /= Void
		do
			station := s
		ensure
			station_set: station = s
		end
		
	link_to (s: STOP) is
			-- Link stop to `s'.
		require
			stop_exists: s /= Void
		do
			next := s
		ensure
			next_set: next = s
		end

invariant
	
	station_exists: station /= Void
	is_linked_definition: is_linked = (next /= Void)

end -- class METRO_STOP

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
