indexing
	description:
		"Objects representing the map of Paris"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach, Michela Pedroni"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class PLACE_SPOTLIGHTER inherit

	TWO_STEP_ANIMATION
		redefine
			end_time, reset
		end

	DISPLAYER_ACCESSOR
		undefine 
			out 
		end

create

	make

feature {NONE} -- Initialization

	make (a_place: PLACE) is
			-- Create spotlighter for `a_place'.
		require
			a_place_exists: a_place /= Void
		do
			internal_place := a_place
		ensure
			place_set: internal_place = a_place
		end

feature -- Access

	End_time: INTEGER is
			-- End time of animation
		once
			Result := 5000
		end

feature -- Basic operations

	first_action is
			-- Do first action.
		do
			set_place_displayer (internal_place)
			place_displayer.mark
		end

	second_action is
			-- Do second action.
		do
			set_place_displayer (internal_place)
			place_displayer.unmark
		end

	reset is
			-- Reset if animation is cancelled.
		do
			set_place_displayer (internal_place)
			place_displayer.unmark
			Precursor
		end

feature -- Attributes

	internal_place: PLACE 
			-- Internal place
	
invariant
	
	place_set: internal_place /= Void
	
end -- class PLACE_SPOTLIGHTER

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Patrick Schoenbach <pschoenb@gmx.de>
--|
--|--------------------------------------------------------
