indexing
	description: 
		"[
			Fancy line that uses stops to get created
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.2 $"

class FANCY_LINE inherit 

	SIMPLE_LINE
	
	SHARED_FACTORY
	
create make_line 

feature -- Initialization

	make_line (a_name: STRING) is
			-- Create a line with name `a_line'.
		require
			a_name_exists: a_name /= Void
		local
			l: LINE
		do
			if factory.city.lines.has (a_name) then
				-- Delete the line
				from
					l := factory.city.lines.item (a_name)
				until
					l.sw_to_ne_line.count = 0
				loop
					l.prune_link (l.sw_to_ne_line.first_link)				
				end
				factory.city.lines.remove (a_name)
			end
			factory.build_line (a_name, "metro", factory.city)
			internal_line := factory.line
			set_line_displayer (internal_line)
			line_displayer.set_line_thickness (4)
			line_displayer.set_dashed (False)
		end

feature -- Basic operations

	set_first_stop (a_stop: STOP) is
			-- Set `a_stop' to be the first stop and create links for all the stops attached to it.
		require
			a_stop_exists: a_stop /= Void
			not_set: count = 1
		local
			s: STOP
		do
			internal_place := a_stop.station
			from
				s := a_stop.next
			until
				s = Void
			loop
				extend (s.station)
				s := s.next
			end
		end
		
end -- class FANCY_LINE

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------

