indexing
	description: 
		"[
			Routes that are displayable
		 ]"

	status:	"See notice at end of class"
	author: "Sibylle Aregger, Rolf Bruderer"
	date: "$Date: 2004/10/12 08:26:00 $"
	revision: "$Revision: 1.0 $"

class DISPLAYABLE_ROUTE inherit

	ROUTE
	
	TWO_STEP_ANIMATION
		rename 
			set_up as animate 
		redefine 
			animate,
			reset
		end		
	
	DISPLAYER_ACCESSOR
	
	SHARED_CITY

create
	make, make_from_route, make_from_origin_and_destination
	
	
feature -- Creation

	make_from_origin_and_destination (a_origin, a_destination: PLACE) is
			-- Create with shortest path from `a_origin' to `a_destination'
		local
			route: ROUTE
			env: EV_ENVIRONMENT
			mc: MAIN_CONTROLLER
			n: NETWORK
			route_calculator: ROUTE_CALCULATOR
		do
			origin := a_origin
			destination := a_destination
			check
				origin /= Void and destination /= Void
			end
			create env
			create internal_timeline.make
			mc ?= env.application
			from
				mc.selected_places.start	
			until
				mc.selected_places.off
			loop
				set_place_displayer (mc.selected_places.item)
				place_displayer.unmark
				mc.selected_places.forth
			end
			mc.selected_places.wipe_out
			mc.selected_places.extend (origin)
			mc.selected_places.extend (destination)
			n := city.transport_network
			create route_calculator.make (n)
			
			route_calculator.set_dijkstra_shortest_path_calculator
			route := route_calculator.calculate_route (mc.selected_places)
			make_from_route (route)
		end
	
	make_from_route (a_route: ROUTE) is
			-- Create from route.
		do
			create places_to_visit.make
			places_to_visit.copy (a_route.places_to_visit)
			
			create places_on_route.make
			places_on_route.copy (a_route.places_on_route)
			
			create links.make
			links.copy (a_route.links)
			origin := places_to_visit.first
			destination := places_to_visit.last
		end
		
feature -- Basic operations

	animate is
			-- Animate and highlight route between Station Madeleine and Tour Eiffel.
		local
			env: EV_ENVIRONMENT
			mc: MAIN_CONTROLLER
			n: NETWORK
			animation_generator: ROUTE_ANIMATION_GENERATOR
			obj: ANIMATABLE_SPOT
		do
			origin := city.places.item ("Station Madeleine")
			destination := city.places.item ("Tour Eiffel")
			check 
				origin /= Void and destination /= Void 
			end
			Precursor
			create env
			create internal_timeline.make
			mc ?= env.application
			from
				mc.selected_places.start
			until
				mc.selected_places.off
			loop
				set_place_displayer (mc.selected_places.item)
				place_displayer.unmark
				mc.selected_places.forth
			end
			mc.selected_places.wipe_out
			mc.selected_places.extend (origin)
			mc.selected_places.extend (destination)
			n := city.transport_network
			create animation_generator
			
			internal_timeline.set_canvas (mc.main_window.canvas)
			animation_generator.build_route_animation (Current)
			obj := animation_generator.animation_object
			internal_timeline.extend (obj)
			internal_timeline.add_stop_action (agent obj.unregister)
			set_city_displayer (city)
			internal_timeline.add_stop_action (agent city_displayer.remove_command (obj))
			internal_timeline.add_stop_action (agent internal_timeline.reset)
		end

feature {NONE} -- Implementation

	first_action is
			-- Mark places and highlight route, start animation.
		do
			set_place_displayer (origin)
			place_displayer.mark
			set_place_displayer (destination)
			place_displayer.mark
			links.do_all (agent highlight (True, ?))
			timeline.canvas.refresh
			internal_timeline.start
		end
		
	second_action is
			-- Unmark places, unhighlight route, stop animation
		local
			env: EV_ENVIRONMENT
			mc: MAIN_CONTROLLER
		do
			create env
			mc ?= env.application
			set_place_displayer (origin)
			place_displayer.unmark
			set_place_displayer (destination)
			place_displayer.unmark
			links.do_all (agent highlight (False, ?))
			mc.selected_places.wipe_out
			timeline.canvas.refresh
		end

	reset is
			-- Reset display of city if animation is cancelled
		local
			mc: MAIN_CONTROLLER
		do
			if internal_timeline.running then
				internal_timeline.stop
			end
			from
				links.start
			until
				links.off
			loop
				set_link_displayer (links.item)
				link_displayer.unhighlight
				links.forth
			end
			set_place_displayer (origin)
			place_displayer.unmark
			set_place_displayer (destination)
			place_displayer.unmark
			mc ?= (create {EV_ENVIRONMENT}).application
			mc.selected_places.wipe_out
			Precursor
		end
		
feature -- Attributes

	origin: PLACE
			-- first station of the route

	destination: PLACE
			-- last station of the route

feature {NONE} -- Implementation	

	internal_timeline: TIMELINE
			-- Timeline used for animation
	
	highlight (on: BOOLEAN; a_link:LINK) is
			-- Set/unset highlight for `a_link'.
		do
			if on then
				set_link_displayer (a_link)
				link_displayer.highlight
			else
				set_link_displayer (a_link)
				link_displayer.unhighlight
			end
		end
		
end -- class DISPLAYABLE_ROUTE

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
