indexing
	description: "Dialog box to start new multiplayergame"
	status:	"Alpha"
	author: "Matthias Geel, ETH Zurich"
	date: "$Date: 2005/01/15 19:23:00 $"
	revision: "$Revision: 0.1 $"
	version: "0.4.1.5"
class
	MULTIPLAYER_DIALOG

inherit
	EV_DIALOG
		redefine
			initialize
		end

	MAIN_WINDOW_CONSTANTS
		export
			{NONE} all
		undefine
			default_create, copy
		end

	KL_SHARED_FILE_SYSTEM
		undefine
			default_create, copy
		end


create
	default_create

feature -- Access

	agent_button, hunter_button: EV_RADIO_BUTTON
	start_button, cancel_button: EV_BUTTON
	
	ip_label, port_label: EV_LABEL
	ip_address: EV_TEXT_FIELD
	port: EV_TEXT_FIELD

feature {NONE}-- Initialization

	initialize is
			-- Initialize `Current'.
		local 
			pixmap: EV_PIXMAP
			row1, row2, row3: EV_HORIZONTAL_BOX
			vertical_box: EV_VERTICAL_BOX
		do
			Precursor {EV_DIALOG}

			--  Initialize dialog with tile and `pixmap'.
			set_title (Dialog_multiplayer_title)
			create pixmap
			pixmap.set_with_named_file (File_system.pathname (Image_directory, Dialog_icon + Image_extension))
			set_icon_pixmap (pixmap)

			-- Create all widgets.
			create vertical_box
			create row1
			create row2
			create row3
			create agent_button
			create hunter_button
			create ip_label
			create ip_address
			create start_button
			create cancel_button
			create port
			create port_label
			
			-- Build_widget_structure.
			extend (vertical_box)
			vertical_box.extend (row1)
			row1.extend (agent_button)
			row1.extend (hunter_button)
			
			vertical_box.extend (row2)
			row2.extend (ip_label)
			row2.extend (ip_address)
			row2.extend (port_label)
			row2.extend (port)
			
			vertical_box.extend (row3)
			row3.extend (start_button)
			row3.extend (cancel_button)
			
			agent_button.set_text ("Estate Agent")
			agent_button.set_tooltip ("You play the Estate Agent")
			hunter_button.set_text ("Flat Hunter")
			hunter_button.set_tooltip ("You play the Flat Hunters")
			ip_label.align_text_left
			ip_label.set_minimum_width (75)
			ip_label.set_text ("Connect to IP:")
			ip_address.set_minimum_width (100)
			ip_address.set_capacity (15)
			ip_address.set_text ("localhost")
			port_label.align_text_left
			port_label.set_minimum_width (28)
			port_label.set_text ("Port:")
			port.set_minimum_width (50)
			port.set_capacity(5)
			port.set_text("1234")
			
			start_button.set_text ("Start")
			start_button.set_minimum_width (100)
			cancel_button.set_text ("Cancel")
			cancel_button.set_minimum_width (100)
			set_default_push_button (start_button)
			set_default_cancel_button (cancel_button)
		end
feature
		
--		change_ip_label is
--				-- Changes the label next to the textfields
--			do
--				if agent_button.is_selected then
--					ip_label.set_text("Connect to IP:")
--					ip_address.disable_edit
--					ip_address.set_text ("localhost")
--				elseif hunter_button.is_selected then
--					ip_label.set_text("Connect to IP:")
--					ip_address.enable_edit
--					ip_address.set_text("localhost")
--				end
--			end
			
end