indexing
	description: "Main window for flat_hunter game"
	status:	"See notice at end of class"
	author: "Marcel Kessler, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.11 $"

class MAIN_WINDOW inherit
	
	EV_TITLED_WINDOW
		redefine
			initialize,
			is_in_default_state
		end

	MAIN_WINDOW_CONSTANTS
		export
			{NONE} all
		undefine
			default_create, copy
		end

	KL_SHARED_FILE_SYSTEM
		undefine
			default_create, copy
		end
		
create
	default_create

feature {NONE} -- Window initialization

	initialize is
			-- Build the interface for this window.
		do
			Precursor {EV_TITLED_WINDOW}
			build_menu_bar
			build_utility_bar
			build_main_container
			build_button_bar
			build_cursors
			extend (main_container)
			set_title (Window_title)
			set_size (Window_width, Window_height)
		end
		
	environment: EV_ENVIRONMENT
			-- Application environment

	is_in_default_state: BOOLEAN is
			-- Is the window in its default state
			-- (as stated in `initialize')
		do
			Result := (width = Window_width) and then
				(height = Window_height) and then
				(title.is_equal (Window_title))
		end

feature -- Basic operations

	set_tool_bar_sensitivity (sensitive: BOOLEAN) is
			-- Set sensitivity of all tool bar buttons according to `sensitive'.
		require
			tool_bar_exists: tool_bar /= Void
		local
			b: EV_BUTTON
			i: INTEGER
			pic: EV_PIXMAP
		do
			from
				tool_bar.start
				i := 1
			until
				tool_bar.after
			loop
				b ?= tool_bar.item
				if b /= Void then
					create pic
					if sensitive then
						b.enable_sensitive
						pic.set_with_named_file (File_system.pathname (Image_directory, (Button_images @ i) + Image_extension))
					else
						b.disable_sensitive
						pic.set_with_named_file (File_system.pathname (Image_directory, (Button_images @ i + Inactivity_suffix + Image_extension)))
					end
					b.set_pixmap (pic)
					i := i + 1
				end
				tool_bar.forth
			end
		end
		
feature -- Window elements

	split_area: EV_VERTICAL_BOX
			-- Vertical split area for layout structor.
	
	file_menu: EV_MENU
			-- "File" menu for this window (contains New, Open, Close, Exit...)
			
	file_close_item: EV_MENU_ITEM 
			-- Menu item that closes the application
	
	file_start_item: EV_MENU_ITEM
			-- Menu item that (re-)starts the game
	
	file_break_item: EV_MENU_ITEM
			-- Menu item for the break action

	help_about_item: EV_MENU_ITEM
			-- Menu item that opens the About dialog
			
	help_menu: EV_MENU
			-- "Help" menu for this window (contains About...)
			
	zoom_in_button: EV_BUTTON
			-- Button to zoom in
	
	zoom_out_button: EV_BUTTON
			-- Button to zoom out
			
	selection_button: EV_TOGGLE_BUTTON
			-- Button to mark a stop
	
	move_button: EV_TOGGLE_BUTTON
			-- Move map with left mouse button
			
	center_button: EV_BUTTON
			-- Center on player

	name_display_button: EV_TOGGLE_BUTTON
			-- Toggle name display button
	
	tool_bar: EV_HORIZONTAL_BOX
			-- Zoom bottons etc.
			
	utility_bar: EV_HORIZONTAL_BOX
			-- Useful information about game stats
	
	canvas: TRAFFIC_CANVAS
			-- The Canvas Widget
			
	main_container: EV_VERTICAL_BOX
			-- Main container (contains all widgets displayed in this window)

	viewport: EV_VIEWPORT
			-- To display the canvas
			
	agent_moves_text: EV_TEXT
			-- Text displaying actual agent position

	player_stat_notebook: EV_NOTEBOOK
			-- Tabbed pane to display statistics for each player
			
	game_stat_text: EV_TEXT
			-- Text displaying actual game statistics 

feature {NONE} -- Window setup

	build_main_container is
			-- Create and populate `main_container'.
		require
			main_container_not_yet_created: main_container = Void
		do
			create viewport
			viewport.set_minimum_height (400)
			create canvas.make
			viewport.extend (canvas)
			create main_container
			canvas.set_zoom_limits (0.2, 2.0)
			create split_area
			split_area.extend (viewport)
			split_area.extend (utility_bar)
			split_area.disable_item_expand (utility_bar)
			main_container.extend (split_area)
		ensure
			main_container_created: main_container /= Void
		end

	build_utility_bar is
			-- Create and populate `utility_bar'.
		do
			create utility_bar
			create agent_moves_text
			create player_stat_notebook
			create game_stat_text
			game_stat_text.set_minimum_width_in_characters (10)
			game_stat_text.disable_edit
			game_stat_text.set_minimum_height (130)
			player_stat_notebook.set_minimum_width (200) 
			agent_moves_text.disable_edit
			utility_bar.extend (agent_moves_text)
			utility_bar.extend (player_stat_notebook)
			utility_bar.extend (game_stat_text)
			utility_bar.disable_item_expand (game_stat_text)
		end
		
	build_menu_bar is
			-- Create and populate `standard_menu_bar'.
		require
			no_menu_bar: menu_bar = Void
		local
			m_bar: EV_MENU_BAR
		do
			-- Create the menu bar.
			create m_bar

			-- Add the "File" menu.
			create file_menu.make_with_text (File_menu_text)
			create file_start_item.make_with_text (File_start_item_text)
			create file_break_item.make_with_text (File_break_item_text)
			file_menu.extend (file_start_item)
			file_menu.extend (create {EV_MENU_SEPARATOR})
			file_menu.extend (file_break_item)
			file_menu.extend (create {EV_MENU_SEPARATOR})
			create file_close_item.make_with_text (File_exit_item_text)
			file_menu.extend (file_close_item)
			m_bar.extend (file_menu)

			-- Add the "Help" menu.
			create help_menu.make_with_text (Help_menu_text)
			create help_about_item.make_with_text (Help_about_item_text)
			help_menu.extend (help_about_item)
			m_bar.extend (help_menu)
			
			-- Set the menu bar for this window.
			set_menu_bar (m_bar)
		ensure
			menu_bar_exists: menu_bar /= Void
			menu_bar_not_empty: not menu_bar.is_empty
		end

	build_button_bar is
			-- Create and populate `button_bar'.
		local
			sep: EV_VERTICAL_SEPARATOR
		do
			create tool_bar
			tool_bar.set_padding (Button_padding)

			create zoom_in_button.make_with_text_and_action ("", agent Canvas.zoom_in (Zoom_factor_stepwise))
			zoom_in_button.set_tooltip (Zoom_in_tooltip)
			tool_bar.extend (zoom_in_button)
			tool_bar.disable_item_expand (zoom_in_button)

			create zoom_out_button.make_with_text_and_action ("", agent Canvas.zoom_out (Zoom_factor_stepwise))
			zoom_out_button.set_tooltip (Zoom_out_tooltip)
			tool_bar.extend (zoom_out_button)
			tool_bar.disable_item_expand (zoom_out_button)

			create sep
			tool_bar.extend (sep)
			tool_bar.disable_item_expand (sep)
			
			create selection_button
			selection_button.set_tooltip (Selection_tooltip)
			selection_button.select_actions.extend (agent set_selection_mode) -- toggle_procedure (selection_button))
			tool_bar.extend (selection_button)
			tool_bar.disable_item_expand (selection_button)

 			create move_button
			move_button.set_tooltip (Move_tooltip)
			move_button.select_actions.extend (agent set_move_mode)
			tool_bar.extend (move_button)
			tool_bar.disable_item_expand (move_button)

			create sep
			tool_bar.extend (sep)
			tool_bar.disable_item_expand (sep)

			create center_button
			center_button.set_tooltip (Center_tooltip)
			tool_bar.extend (center_button)
			tool_bar.disable_item_expand (center_button)

			create name_display_button
			name_display_button.toggle
			name_display_button.set_tooltip (Name_display_tooltip)
			tool_bar.extend (name_display_button)
			tool_bar.disable_item_expand (name_display_button)

			create sep
			tool_bar.extend (sep)
			tool_bar.disable_item_expand (sep)

			upper_bar.extend (create {EV_HORIZONTAL_SEPARATOR})
			upper_bar.extend (tool_bar)
			tool_bar.set_border_width (5)
			set_tool_bar_images (True)
		end

	toggle_procedure (toggled_button: EV_TOGGLE_BUTTON) is
			-- Disable and select the toggled button, do the opposite with the other toggle buttons.
		local
			is_already_selected: BOOLEAN
		do
			if toggled_button.is_selected then
				is_already_selected := True
			end

			if toggled_button = selection_button then
				selection_button.disable_select
			elseif toggled_button = move_button then
				move_button.disable_select
			end
			selection_button.select_actions.block
			move_button.select_actions.block
			
			selection_button.disable_select
			move_button.disable_select

			if not is_already_selected then
				toggled_button.enable_select
			end
			
			selection_button.select_actions.resume
			move_button.select_actions.resume
		end
		
	set_tool_bar_images (sensitive: BOOLEAN) is
			-- Set sensitivity state of button bar buttons to `sensitive'.
		require
			tool_bar_exists: tool_bar /= Void
		local
			b: EV_BUTTON
			i: INTEGER
			pic: EV_PIXMAP
		do
			from
				tool_bar.start
				i := 1
			until
				tool_bar.after
			loop
				b ?= tool_bar.item
				if b /= Void then
					create pic
					if sensitive then
						b.enable_sensitive
						pic.set_with_named_file (File_system.pathname (Image_directory, (Button_images @ i) + Image_extension))
					else
						b.disable_sensitive
						pic.set_with_named_file (File_system.pathname (Image_directory, (Button_images @ i + Inactivity_suffix + Image_extension)))
					end
					b.set_pixmap (pic)
					i := i + 1
				end
				tool_bar.forth
			end
		end
		
feature {NONE} -- Implementation (Cursors)

	move_cursor: EV_CURSOR
			-- Cursor for move mode

	information_cursor: EV_CURSOR
			-- Cursor for information mode

	build_cursors is
			-- Build cursors.
		require
			no_move_cursor: move_cursor = Void
			no_information_cursor: information_cursor = Void
		local
			pic: EV_PIXMAP
		do
			create pic
			pic.set_with_named_file (File_system.pathname (Image_directory, Move_cursor_shape + Image_extension))
			create move_cursor.make_with_pixmap 
				(pic, Cursor_hotspot_x, Cursor_hotspot_y)

			create pic
			pic.set_with_named_file (File_system.pathname (Image_directory, Info_cursor_shape + Image_extension))
			create information_cursor.make_with_pixmap 
				(pic, 0, 0)
		ensure
			move_cursor_exists: move_cursor /= Void
			information_cursor_exists: information_cursor /= Void
		end

feature {NONE} -- Implementation (Modes)

	set_selection_mode is
			-- Set element selection mode.
		do
			mode := Selection_mode
			Canvas.set_pointer_style 
				((create {EV_STOCK_PIXMAPS}).Standard_cursor)

			selection_button.select_actions.block
			move_button.select_actions.block
			
			if not selection_button.is_selected then
				selection_button.enable_select
			end

			move_button.disable_select

			selection_button.select_actions.resume
			move_button.select_actions.resume
		ensure
			mode_set: mode = Selection_mode
		end

	set_move_mode is
			-- Set map move mode.
		do
			mode := Move_mode
			Canvas.set_pointer_style (move_cursor)

			selection_button.select_actions.block
			move_button.select_actions.block
			
			if not move_button.is_selected then
				move_button.enable_select
			end

			selection_button.disable_select

			selection_button.select_actions.resume
			move_button.select_actions.resume
		ensure
			mode_set: mode = Move_mode
		end

feature {MAIN_CONTROLLER} -- Status setting (Application)

	mode: INTEGER
			-- Interface mode

	add_player_info_box (a_player: PLAYER) is
			-- Extend notebook with another player info box.
		local
			player_displayer: PLAYER_INFO_BOX
		do
			create player_displayer.set_picture (a_player.displayer.pic)
			player_displayer.set_text (a_player.displayer.statistics)
			player_displayer.set_data (a_player.name)
			player_stat_notebook.extend (player_displayer)
			player_stat_notebook.set_item_text (player_displayer, a_player.name)
		end
		
	update_player_info_box (a_player: PLAYER) is
			-- Update the player statistics.
		local
			player_displayer: PLAYER_INFO_BOX
			estate_agent: ESTATE_AGENT
		do
			player_displayer ?= player_stat_notebook.retrieve_item_by_data (a_player.name, False)
			if player_displayer /= Void then
				player_displayer.set_text (a_player.displayer.statistics)
			end
			estate_agent ?= a_player
			if estate_agent /= Void then
				agent_moves_text.set_text (estate_agent.displayer.agent_moves)
				if estate_agent.displayer.visible then
					player_stat_notebook.select_item (player_displayer)		
				end
			else
				player_stat_notebook.select_item (player_displayer)		
			end
		end
		
end

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Marcel Kessler <kesslema@student.ethz.ch>
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--| 	Rolf Bruderer <bruderer@computerscience.ch>
--|
--|--------------------------------------------------------
