indexing
	description: "Vertical box for MAIN_WINDOW"
	status:	"See notice at end of class"
	author: "Marcel Kessler, ETH Zurich"
	date: "$Date: 2004/10/15 14:06:10 $"
	revision: "$Revision: 1.5 $"

class
	PLAYER_INFO_BOX

inherit
	EV_VERTICAL_BOX
		redefine
			initialize,
			is_in_default_state
		end

create
	set_picture

feature {NONE} -- Initialization

	initialize is
			-- Populate the dialog box.
		do
			Precursor

			create text_field
			create box
			box.extend (image)
			box.set_padding (0)
			box.disable_item_expand (image)
			Current.extend (box)
			image.set_minimum_size (42, 42)
			text_field.align_text_left
			Current.extend (text_field)
			text_field.set_text ("")
			Current.disable_item_expand (box)
		end

feature {NONE} -- Access

	text_field: EV_LABEL	
	
	image: EV_PIXMAP

	box: EV_HORIZONTAL_BOX
	
feature {NONE} -- Status report

	is_in_default_state: BOOLEAN is
			-- Is `Current' in its default state.
		do
			Result := --Precursor {EV_WIDGET_LIST} and (
			(	not is_homogeneous and
				border_width = 0 and
				padding = 0			
			)
		end

feature {MAIN_WINDOW} -- Status setting

	set_text (stats: STRING) is
			-- Update player text.
		do
			text_field.set_text(stats)
		end
	
	set_picture (pic: EV_PIXMAP) is
			-- Update player picture.
		do
			image := pic
			default_create
		end

end

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Marcel Kessler <kesslema@student.ethz.ch>
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--| 	Rolf Bruderer <bruderer@computerscience.ch>
--|
--|--------------------------------------------------------
