indexing
	description: "Dialog box to start new game"
	status:	"See notice at end of class"
	author: "Marcel Kessler, ETH Zurich"
	date: "$Date: 2004/10/15 14:06:10 $"
	revision: "$Revision: 1.3 $"

class
	GAME_DIALOG

inherit
	EV_DIALOG
		redefine
			initialize
		end

	MAIN_WINDOW_CONSTANTS
		export
			{NONE} all
		undefine
			default_create, copy
		end

	KL_SHARED_FILE_SYSTEM
		undefine
			default_create, copy
		end


create
	default_create

feature {NONE}-- Initialization

	initialize is
			-- Initialize `Current'.
		local 
			l_ev_horizontal_box_1: EV_HORIZONTAL_BOX
			l_ev_vertical_box_1, l_ev_vertical_box_2: EV_VERTICAL_BOX
			l_ev_label_1, l_ev_label_2, l_ev_label_3: EV_LABEL
			pixmap: EV_PIXMAP
		do
			Precursor {EV_DIALOG}

			--  Initialize dialog with tile and `pixmap'.
			set_title (Dialog_title)
			create pixmap
			pixmap.set_with_named_file (File_system.pathname (Image_directory, Dialog_icon + Image_extension))
			set_icon_pixmap (pixmap)

			-- Create all widgets.
			create start_button
			create cancel_button
			create l_ev_horizontal_box_1
			create l_ev_vertical_box_1
			create l_ev_label_1
			create hunt_mode
			create escape_mode
			create versus_mode
			create demo_mode
			create l_ev_vertical_box_2
			create l_ev_label_2
			create number_of_hunters
			create l_ev_label_3
			create little_map
			create big_map
			
			-- Build_widget_structure.
			extend (l_ev_horizontal_box_1)
			l_ev_horizontal_box_1.extend (l_ev_vertical_box_1)
			l_ev_vertical_box_1.extend (l_ev_label_1)
			l_ev_vertical_box_1.extend (hunt_mode)
			l_ev_vertical_box_1.extend (escape_mode)
			l_ev_vertical_box_1.extend (versus_mode)
			l_ev_vertical_box_1.extend (demo_mode)
			l_ev_vertical_box_1.extend (start_button)
			l_ev_horizontal_box_1.extend (l_ev_vertical_box_2)
			l_ev_vertical_box_2.extend (l_ev_label_2)
			l_ev_vertical_box_2.extend (number_of_hunters)
			l_ev_vertical_box_2.extend (l_ev_label_3)
			l_ev_vertical_box_2.extend (little_map)
			l_ev_vertical_box_2.extend (big_map)
			l_ev_vertical_box_2.extend (cancel_button)
			l_ev_label_1.set_text ("Game Mode:")
			l_ev_label_1.align_text_left
			hunt_mode.set_text ("Hunt")
			hunt_mode.set_tooltip ("Find the agent!")
			escape_mode.set_text ("Escape")
			escape_mode.set_tooltip ("Avoid the hunters!")
			versus_mode.set_text ("Versus")
			versus_mode.set_tooltip ("Hunters vs. Agent")
			demo_mode.set_text ("Demo")
			demo_mode.set_tooltip ("Sit back and enjoy...")
			l_ev_label_2.set_text ("# Hunters:")
			l_ev_label_2.align_text_left
			number_of_hunters.set_text ("3")
			number_of_hunters.set_tooltip ("Number of hunters?")
			number_of_hunters.value_range.adapt (create {INTEGER_INTERVAL}.make (1, 8))
			number_of_hunters.set_value (3)
			l_ev_label_3.set_text ("Map Size:")
			l_ev_label_3.align_text_left
			little_map.set_text ("Little Map")
			little_map.set_tooltip ("zurich_little_city.xml")
			big_map.set_text ("Big Map")
			big_map.set_tooltip ("zurich_big_city.xml")
			start_button.set_text ("Start")
			start_button.set_minimum_width (100)
			cancel_button.set_text ("Cancel")
			cancel_button.set_minimum_width (100)
			set_default_push_button (start_button)
			set_default_cancel_button (cancel_button)
		end

feature -- Access

	hunt_mode, escape_mode, versus_mode, demo_mode, little_map, big_map: EV_RADIO_BUTTON
	number_of_hunters: EV_SPIN_BUTTON
	start_button, cancel_button: EV_BUTTON
	
end

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Marcel Kessler <kesslema@student.ethz.ch>
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--| 	Rolf Bruderer <bruderer@computerscience.ch>
--|
--|--------------------------------------------------------
