indexing
	description: "Brain controled by human user"
	status:	"See notice at end of class"
	author: "Marcel Kessler, ETH Zurich"
	date: "$Date: 2004/10/15 14:06:10 $"
	revision: "$Revision: 1.3 $"

class
	HUMAN

inherit
	BRAIN

feature {ESTATE_AGENT} -- Basic operations

	choose_estate_agent_move (possible_moves: LINKED_LIST [LINK]; my_location: PLACE; last_estate_agent_location: PLACE) is
			-- Choose next move for the estate agent.
		do
			chosen_move := Void
			if selected_place /= Void then
				from
					possible_moves.start
				until
					possible_moves.after
				loop
					if possible_moves.item.other_end (my_location).name.is_equal (selected_place.name) then
						chosen_move := possible_moves.item
					end
					possible_moves.forth
				end
				selected_place := Void
			end
		ensure then
			result_has_place_if_not_void: chosen_move /= Void implies (chosen_move.from_place = my_location or chosen_move.to_place = my_location)
		end		

feature {FLAT_HUNTER} -- Basic operations

	choose_flat_hunter_move (possible_moves: LINKED_LIST [LINK]; my_location: PLACE; last_estate_agent_location: PLACE) is
			-- Choose next move for a flat hunter.
		do
			chosen_move := Void
			if selected_place /= Void then
				from
					possible_moves.start
				until
					possible_moves.after
				loop
					if possible_moves.item.other_end (my_location).name.is_equal (selected_place.name) then
						chosen_move := possible_moves.item
					end
					possible_moves.forth
				end
				selected_place := Void
			end
		ensure then
			result_has_place_if_not_void: chosen_move /= Void implies (chosen_move.from_place = my_location or chosen_move.to_place = my_location)
		end		

end

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Marcel Kessler <kesslema@student.ethz.ch>
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--| 	Rolf Bruderer <bruderer@computerscience.ch>
--|
--|--------------------------------------------------------
