indexing
	description: 
		"[
			Generator for route animations.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.3 $"

class ROUTE_ANIMATION_GENERATOR inherit
	
	DISPLAYER_ACCESSOR

feature -- Access

	animation_object: ANIMATABLE_SPOT
			-- Animatable spot that is used for the animation

feature -- Basic operations

	build_route_animation (a_route: ROUTE) is
			-- Prepare the route animation for `a_route' by generating the keyframes.
			-- The animation object is available through `animation_object'.
		require
			a_route_exists: a_route /= Void
			a_route_not_empty: not a_route.links.is_empty
		local
			keyframes: ARRAYED_LIST [KEYFRAME]
			src: PLACE
			frame_time: INTEGER
			pos1, pos2: REAL_COORDINATE
			l: LINK
		do
			create keyframes.make (0)
			src := a_route.places_to_visit.first
			create animation_object.make 
				(create {REAL_COORDINATE}.make (src.position.x, src.position.y))
			if src /= a_route.links.first.from_place then
				create pos2.make (a_route.links.first.polypoints.last.x, a_route.links.first.polypoints.last.y)
			else
				create pos2.make (a_route.links.first.polypoints.first.x, a_route.links.first.polypoints.first.y)
			end

			from
				a_route.links.start
			until
				a_route.links.off
			loop
				l := a_route.links.item
				if src /= l.from_place then
					from 
						l.polypoints.finish
						create pos1.make (l.polypoints.item.x, l.polypoints.item.y) 
						frame_time := frame_time + frame_time_increment (pos2, pos1)						
						keyframes.extend (create {KEYFRAME}.make (frame_time, pos1))
						l.polypoints.back
					until
						l.polypoints.off
					loop
						create pos2.make (l.polypoints.item.x, l.polypoints.item.y)
						frame_time := frame_time + frame_time_increment (pos1, pos2)							
						keyframes.extend (create {KEYFRAME}.make (frame_time, pos2))
						create pos1.make (pos2.x, pos2.y)
						l.polypoints.back
					end
					src := l.from_place					
				else --| right direction
					from 
						l.polypoints.start
						create pos1.make (l.polypoints.item.x, l.polypoints.item.y) 
						frame_time := frame_time + frame_time_increment (pos2, pos1)
						keyframes.extend (create {KEYFRAME}.make (frame_time, pos1))
						l.polypoints.forth
					until
						l.polypoints.off
					loop
						create pos2.make (l.polypoints.item.x, l.polypoints.item.y)
						frame_time := frame_time + frame_time_increment (pos1, pos2)							
						keyframes.extend (create {KEYFRAME}.make (frame_time, pos2))
						create pos1.make (pos2.x, pos2.y)
						l.polypoints.forth
					end
					src := l.to_place
				end
				a_route.links.forth
			end
			animation_object.set_color (create {EV_COLOR}.make_with_rgb (0.0, 0.0, 1.0))
			animation_object.set_diameter (8)
			animation_object.set_filled
			animation_object.set_keyframes (keyframes)
		ensure
			animation_object_exists: animation_object /= Void
		end

feature {NONE} -- Implementation

	Units_per_second: DOUBLE is 50.0
			-- Units of movement per second
	
	frame_time_increment (a_coordinate1, a_coordinate2: REAL_COORDINATE): INTEGER is
			-- Increment of the frametime from `a_coordinate1' to `a_coordinate2'
		require
			a_coordinate1_exists: a_coordinate1 /= Void
			a_coordinate2_exists: a_coordinate2 /= Void
		do
			Result := (a_coordinate1.distance (a_coordinate2)/Units_per_second).rounded
		ensure
			Result_positive: Result >= 0
		end

end -- class ROUTE_ANIMATION_GENERATOR

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
