indexing
	description: 
		"[
			Displayers for link objects.
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.3 $"

class LINK_DISPLAYER inherit
	
	LINE_LINK_TYPE_CONSTANTS
	
	ELEMENT_DISPLAYER
		rename 
			element as link
		redefine 
			make,
			link
		end
		
create 
	make

feature -- Initialization

	make (a_link: LINK) is
			-- Creation procedure.
		do
			Precursor (a_link)
		end

feature -- Status report

	dashed: BOOLEAN
			-- Is the link drawn dashed?

	has_point (a_coordinate: REAL_COORDINATE): BOOLEAN is
			-- Is `a_coordinate' on the link?
		do
			-- TODO
		end
		
feature -- Access

	link: LINK
			-- Link that this displayer displays

	line_thickness: INTEGER
			-- Thickness of the line used to draw the link on the canvas

feature -- Constants

	Default_standard_color: EV_COLOR is
			-- Default standard color of place
		once
			create Result.make_with_rgb (0.0, 0.8, 0.0)
		end
		
	Default_highlight_color: EV_COLOR is
			-- Default color of highlighted place
		once
			create Result.make_with_rgb (0.4, 1.0, 0.4)
		end

feature -- Element change

	set_dashed (a_value: BOOLEAN) is
			-- Set `dashed' to `a_value'.
		do
			dashed := a_value
		ensure
			dashed_set: dashed = a_value
		end
		
	set_line_thickness (a_thickness: INTEGER) is
			-- Set `line_thickness' to `a_thickness'.
		require
			a_thickness_valid: a_thickness > 0 and a_thickness < 10
		do
			line_thickness := a_thickness
		ensure
			line_thickness_set: line_thickness = a_thickness
		end		

feature {NONE} -- Implementation

	initialize is
			-- Fill the `basic_representation', `marked_representation', and `highlighted_representation' with the right drawables.
		local
			pl_standard, pl_highlight: DRAWABLE_POLYLINE
		do
			pl_standard := polyline (standard_color, line_thickness)
			pl_highlight := polyline (highlight_color, line_thickness + 4)
			basic_representation.extend (pl_standard)
			highlighted_representation.extend (pl_highlight)
		end

	polyline (a_color: EV_COLOR; a_width: INTEGER): DRAWABLE_POLYLINE is
			-- Return a polyline that goes through the polypoints
		require
			a_color_exists: a_color /= Void
			a_width_valid: a_width > 0
		local
			arr: ARRAYED_LIST [REAL_COORDINATE]
			c: REAL_COORDINATE
		do
			from
				create arr.make (0)
				link.polypoints.start
			until
				link.polypoints.off
			loop
				c := real_coordinate (link.polypoints.item)
				arr.extend (c)
				link.polypoints.forth
			end
			
			create Result.make (arr, 634.0)
			Result.set_color (a_color)
			if dashed then
				Result.enable_dashed_line
			end
			Result.set_width (a_width)
		ensure
			Result_exists: Result /= Void
		end


end -- class LINK_DISPLAYER

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
