indexing
	description: 
		"[
			Displayer for lines on the map
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.4 $"

class LINE_DISPLAYER inherit

	LINE_LINK_TYPE_CONSTANTS
	
	ELEMENT_DISPLAYER
		rename 
			element as line
		redefine 
			make,
			line,
			show,
			mark,
			unmark,
			unhighlight,
			highlight
		end
		
	DISPLAYER_ACCESSOR

create
	make
	
feature -- Initialization

	make (a_line: LINE) is
			-- Creation procedure.
		do
			Precursor (a_line)
		end

feature -- Attributes

	line: LINE
			-- Line that this displayer displays

	line_thickness: INTEGER
			-- Thickness for drawing the links of the line

feature -- Status report

	dashed: BOOLEAN
			-- Is the line drawn dashed?

	has_point (a_coordinate: REAL_COORDINATE): BOOLEAN is
			-- Is `a_coordinate' on the line?
		do
			-- TODO
		end
		
feature -- Element change

	set_line_thickness (a_thickness: INTEGER) is
			-- Set `line_thickness' to `a_line_thickness'.
		require
			thickness_okay: a_thickness > 0 and a_thickness <= 10
		do
			line_thickness := a_thickness
		ensure
			line_thickness_set: line_thickness = a_thickness
		end
		
	set_dashed (a_value: BOOLEAN) is
			-- Set `dashed' to the boolean value `a_value'.
		do
			dashed := a_value
		ensure
			dashed_set: dashed = a_value
		end
	
feature -- Basic operations

	show is
			-- Draw the line on the canvas.
		do
			from
				line.sw_to_ne_line.start
			until
				line.sw_to_ne_line.off
			loop
				if line.sw_to_ne_line.link_for_iteration.has_displayer then
					set_link_displayer (line.sw_to_ne_line.link_for_iteration)
					link_displayer.show
				end
				line.sw_to_ne_line.forth
			end
			from
				line.ne_to_sw_line.start
			until
				line.ne_to_sw_line.off
			loop
				if line.ne_to_sw_line.link_for_iteration.has_displayer then
					set_link_displayer (line.ne_to_sw_line.link_for_iteration)
					link_displayer.show
				end
				line.ne_to_sw_line.forth
			end
			shown := True
			marked := False
			highlighted := False
		end
	
	highlight is
			-- Highlight the line.
		do
			from
				line.sw_to_ne_line.start
			until
				line.sw_to_ne_line.off
			loop
				if line.sw_to_ne_line.link_for_iteration.has_displayer then
					set_link_displayer (line.sw_to_ne_line.link_for_iteration)
					if not link_displayer.highlighted then
						link_displayer.highlight					
					end
				end
				line.sw_to_ne_line.forth
			end
			from
				line.ne_to_sw_line.start
			until
				line.ne_to_sw_line.off
			loop
				if line.ne_to_sw_line.link_for_iteration.has_displayer then
					set_link_displayer (line.ne_to_sw_line.link_for_iteration)
					if not link_displayer.highlighted then
						link_displayer.highlight					
					end
				end
				line.ne_to_sw_line.forth
			end
			highlighted := True
		end
		
	mark is
			-- Mark the line.
		do
			from
				line.sw_to_ne_line.start
			until
				line.sw_to_ne_line.off
			loop
				if line.sw_to_ne_line.link_for_iteration.has_displayer then
					set_link_displayer (line.sw_to_ne_line.link_for_iteration)
					if not link_displayer.marked then
						link_displayer.mark					
					end
				end
				line.sw_to_ne_line.forth
			end
			from
				line.ne_to_sw_line.start
			until
				line.ne_to_sw_line.off
			loop
				if line.ne_to_sw_line.link_for_iteration.has_displayer then
					set_link_displayer (line.ne_to_sw_line.link_for_iteration)
					if not link_displayer.marked then
						link_displayer.mark					
					end
				end
				line.ne_to_sw_line.forth
			end
			marked := True
		end
		
	unhighlight is
			-- Unhighlight the line.
		do
			from
				line.sw_to_ne_line.start
			until
				line.sw_to_ne_line.off
			loop
				if line.sw_to_ne_line.link_for_iteration.has_displayer then
					set_link_displayer (line.sw_to_ne_line.link_for_iteration)
					if link_displayer.highlighted then
						link_displayer.unhighlight					
					end
				end
				line.sw_to_ne_line.forth
			end
			from
				line.ne_to_sw_line.start
			until
				line.ne_to_sw_line.off
			loop
				if line.ne_to_sw_line.link_for_iteration.has_displayer then
					set_link_displayer (line.ne_to_sw_line.link_for_iteration)
					if link_displayer.highlighted then
						link_displayer.unhighlight					
					end
				end
				line.ne_to_sw_line.forth
			end
			highlighted := False
		end
		
	unmark is
			-- Unmark the line.
		do
			from
				line.sw_to_ne_line.start
			until
				line.sw_to_ne_line.off
			loop
				if line.sw_to_ne_line.link_for_iteration.has_displayer then
					set_link_displayer (line.sw_to_ne_line.link_for_iteration)
					if link_displayer.marked then
						link_displayer.unmark					
					end
				end
				line.sw_to_ne_line.forth
			end
			from
				line.ne_to_sw_line.start
			until
				line.ne_to_sw_line.off
			loop
				if line.ne_to_sw_line.link_for_iteration.has_displayer then
					set_link_displayer (line.ne_to_sw_line.link_for_iteration)
					if link_displayer.marked then
						link_displayer.unmark					
					end
				end
				line.ne_to_sw_line.forth
			end
			marked := False
		end
		
feature -- Constants

	Default_standard_color: EV_COLOR is
			-- Default standard color of place
		once
			create Result.make_with_rgb (0.0, 0.8, 0.0)
		end
		
	Default_highlight_color: EV_COLOR is
			-- Default color of highlighted place
		once
			create Result.make_with_rgb (0.4, 1.0, 0.4)
		end
	
feature -- Basic operations

	initialize is
			-- Initialize the line display. 
		do
			from
				line.sw_to_ne_line.start
			until
				line.sw_to_ne_line.off
			loop
				if line.sw_to_ne_line.link_for_iteration.has_displayer then
					set_link_displayer (line.sw_to_ne_line.link_for_iteration)
					link_displayer.set_highlight_color (highlight_color)
					link_displayer.set_standard_color (standard_color)
					link_displayer.set_dashed (dashed)
					link_displayer.set_line_thickness (line_thickness)
					link_displayer.reinitialize
				end
				line.sw_to_ne_line.forth
			end
			from
				line.ne_to_sw_line.start
			until
				line.ne_to_sw_line.off
			loop
				if line.ne_to_sw_line.link_for_iteration.has_displayer then
					set_link_displayer (line.ne_to_sw_line.link_for_iteration)
					link_displayer.set_highlight_color (highlight_color)
					link_displayer.set_standard_color (standard_color)
					link_displayer.set_dashed (dashed)
					link_displayer.set_line_thickness (line_thickness)
					link_displayer.reinitialize
				end
				line.ne_to_sw_line.forth
			end
		end
		
end -- class LINE_DISPLAYER

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
