indexing
	description: 
		"[
			Adaptor used to adapt the city parser to parse and process visualization elements
		 ]"
		 
	author: "Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.2 $"

class XML_ADAPTOR

feature -- Basic operations

	adapt_xml_registry (a_city_parser: CITY_PARSER) is
			-- Add new node_processors to `a_city_parser'.
		require
			a_city_parser_exists: a_city_parser /= Void
		do
			a_city_parser.register_processor (create {PLACE_DISPLAYER_NODE_PROCESSOR}.make)
			a_city_parser.register_processor (create {POINT_NODE_PROCESSOR}.make)
			a_city_parser.register_processor (create {COLOR_NODE_PROCESSOR}.make)
			a_city_parser.register_processor (create {POLYGON_NODE_PROCESSOR}.make)
			a_city_parser.register_processor (create {BACKGROUND_NODE_PROCESSOR}.make)
			a_city_parser.register_processor (create {FILE_NODE_PROCESSOR}.make)
			a_city_parser.register_processor (create {LINE_DISPLAYER_NODE_PROCESSOR}.make)
			a_city_parser.register_allowed_subnode ("city", "background")
			a_city_parser.register_allowed_subnode ("place", "place_displayer")
			a_city_parser.register_allowed_subnode ("place_displayer", "point")
			a_city_parser.register_allowed_subnode ("line", "line_displayer")
			a_city_parser.register_allowed_subnode ("line_displayer", "color")
			a_city_parser.register_allowed_subnode ("background", "file")
			a_city_parser.register_allowed_subnode ("background", "polygon")
			a_city_parser.register_allowed_subnode ("polygon", "color") 
			a_city_parser.register_allowed_subnode ("polygon", "point")
		end

end -- class XML_ADAPTOR

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
