indexing
	description:
		"[
			XML processors for <background> elements.
		 ]"

	status:	"See notice at end of class"
	author: "Marcel Kessler & Michela Pedroni, ETH Zurich"
	date: "$Date: 2004/10/20 10:03:04 $"
	revision: "$Revision: 1.2 $"

class BACKGROUND_NODE_PROCESSOR inherit

	NODE_PROCESSOR
		redefine 
			process_subnodes 
		end
		
	DISPLAYER_ACCESSOR

create
	make

feature -- Access

	Name: STRING is	
			-- Name of element to process
		do
			Result := "background"
		end

	Mandatory_attributes: ARRAY [STRING] is
			-- Table of mandatory attributes
		once
			Result := << >>
			Result.compare_objects
		end

feature -- Basic operations

	process is
			-- Process node.
		do
			if has_subnodes then
				process_subnodes
			end
		end

	process_subnodes is
			-- Process subnodes.
		local
			n: XM_ELEMENT
			p: NODE_PROCESSOR
			cd: CITY_DISPLAYER
			file_node_processor: FILE_NODE_PROCESSOR
		do
			from
				subnodes.start
			until
				has_error or subnodes.after
			loop
				n := subnodes.item
				if has_processor (n.name) then
					p := processor (n.name)
						check
							no_error: not p.has_error
								-- Because a new processor was retrieved.
						end
				else
					set_error (Unknown_node_processor, << n.name >>)
				end
				if not has_error then
					p.set_source (n)
					p.set_parent (Current)
					
					p.set_city_factory (city_factory)
					
					if has_target then
						p.set_target (target)
					end
					if not p.has_error then
						p.process
					else
						set_error (p.error_code, p.slots)
					end
					file_node_processor ?= p
					if file_node_processor /= Void then
						if not city_factory.city.has_displayer then
							create cd.make (city_factory.city)
							city_factory.city.set_displayer (cd)
						else
							set_city_displayer (city)
							cd := city_displayer
						end
						if file_node_processor.file /= Void and cd /= Void and then not file_node_processor.file.is_empty then
							cd.set_background_file_name (attribute ("name"))
						end	
					end
				end
				subnodes.forth
			end
		end

end -- class BACKGROUND_NODE_PROCESSOR

--|--------------------------------------------------------
--| This file is Copyright (C) 2004 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Michela Pedroni <michela.pedroni@inf.ethz.ch>
--|
--|--------------------------------------------------------
