indexing
	description:
		"Objects that can execute actions at a certain time"

	status:	"See notice at end of class"
	author: "Patrick Schoenbach"
	date: "$Date: 2004/10/20 10:03:03 $"
	revision: "$Revision: 1.3 $"

deferred class TIMEABLE

feature -- Access

	start_time: INTEGER
			-- Start time offset
			
feature -- Status report

	has_timeline: BOOLEAN is
			-- Has a timeline been set?
		do
			Result := (timeline /= Void)
		end

	is_ready: BOOLEAN is
			-- Is timeable object set up correctly?
		deferred
		end
		
	is_suspended: BOOLEAN is
			-- Is timeable object suspended?
		require
			has_timeline: has_timeline
		do
			Result := timeline.is_suspended (Current)
		end
		
feature -- Status setting

	set_start_time (t: INTEGER) is
			-- Set start time to `t'.
		require
			time_positive: t >= 0
		do
			start_time := t
		ensure
			start_time_set: start_time = t
		end

	set_timeline (t: TIMELINE) is
			-- Set timeline to `t'.
		do
			timeline := t
		ensure
			timeline_set: timeline = t
		end
		
feature -- Basic operations

	execute_timed_action (t: INTEGER) is
			-- Execute action at time `t'.
		require
			has_timeline: has_timeline
			ready: is_ready
			not_suspended: not is_suspended
		deferred
		end

	suspend is
			-- Suspend animation.
		require
			has_timeline: has_timeline
			ready: is_ready
			not_suspended: not is_suspended
		do
			timeline.suspend (Current)
		end

	reset is
			-- Reset timeable object.
		require
			has_timeline: has_timeline
		deferred
		end

	unregister is
			-- Unregister timeable object from timeline.
		require
			has_time_line: has_timeline
		do
			timeline.prune (Current)
			timeline := Void
		ensure
			no_timeline: not has_timeline
		end
		
feature {NONE} -- Implementation

	timeline: TIMELINE
			-- Associated timeline

invariant

	has_timeline_definition: has_timeline = (timeline /= Void)
	
end -- class TIMEABLE

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Patrick Schoenbach <pschoenb@gmx.de>
--|
--|--------------------------------------------------------
