indexing

	description: "[
			A Keyframe decribes the location of an Animatable
			Object at a certain time.
		 	]"
	status:	"See notice at end of class"
	author: "Till G. Bay"
	date: "$Date: 2004/08/25 12:03:42 $"
	revision: "$Revision: 1.2 $"

class KEYFRAME

create

	make,
	from_reals

feature -- Creation

	make (a_time: like time; a_location: like location) is
			-- Create a new keyframe from `a_time' and `a_location'.
		require
			a_location_not_void: a_location /= Void
		do
			time := a_time
			location := a_location
		ensure
			time_set: time = a_time
			location_set: location = a_location
		end
		
	from_reals (a_time: like time; a_x, a_y: REAL) is
			-- Create a keyframe from real coordinates `a_x' , `a_y' and `a_time'.
		do
			make (a_time, create {REAL_COORDINATE}.make (a_x, a_y))
		ensure
			time_set: time = a_time
			location_x_set: location.x = a_x
			location_y_set: location.y = a_y
		end

feature -- Access

	time: INTEGER
			-- The time
		
	location: REAL_COORDINATE
			-- The location

invariant

	location_not_void: location /= Void

end

--|--------------------------------------------------------
--| This file is Copyright (C) 2003 by ETH Zurich.
--|
--| For questions, comments, additions or suggestions on
--| how to improve this package, please write to:
--|
--|     Till G. Bay <tillbay@student.ethz.ch>
--|
--|--------------------------------------------------------
